/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner;

import java.util.ArrayList;
import java.util.List;

class SqlUtils {
    private static final String STATEMENT_DELIMITER = ";";
    private static final String LINE_DELIMITER = "\n";
    private static final String COMMENT_PATTERN = "(--.*)|(((/\\*)+?[\\w\\W]+?(\\*/)+))";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String ESCAPED_BEGIN_CERTIFICATE = "======BEGIN CERTIFICATE=====";
    private static final String ESCAPED_END_CERTIFICATE = "=====END CERTIFICATE=====";

    static List<String> parseStatements(String script) {
        String formatted = SqlUtils.formatSqlFile(script).replaceAll(BEGIN_CERTIFICATE, ESCAPED_BEGIN_CERTIFICATE).replaceAll(END_CERTIFICATE, ESCAPED_END_CERTIFICATE).replaceAll(COMMENT_PATTERN, "").replaceAll(ESCAPED_BEGIN_CERTIFICATE, BEGIN_CERTIFICATE).replaceAll(ESCAPED_END_CERTIFICATE, END_CERTIFICATE);
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder current = null;
        boolean statementSet = false;
        for (String line : formatted.split(LINE_DELIMITER)) {
            String trimmed = line.trim();
            if (trimmed.isBlank()) continue;
            if (current == null) {
                current = new StringBuilder();
            }
            if (trimmed.startsWith("EXECUTE STATEMENT SET")) {
                statementSet = true;
            }
            current.append(trimmed);
            current.append(LINE_DELIMITER);
            if (!trimmed.endsWith(STATEMENT_DELIMITER) || statementSet && !trimmed.equalsIgnoreCase("END;")) continue;
            statements.add(current.toString());
            current = null;
            statementSet = false;
        }
        return statements;
    }

    static String formatSqlFile(String content) {
        String trimmed = content.trim();
        StringBuilder formatted = new StringBuilder();
        formatted.append(trimmed);
        if (!trimmed.endsWith(STATEMENT_DELIMITER)) {
            formatted.append(STATEMENT_DELIMITER);
        }
        formatted.append(LINE_DELIMITER);
        return formatted.toString();
    }

    private SqlUtils() {
        throw new UnsupportedOperationException();
    }
}

