/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.connector.kafka;

import com.datasqrl.flinkrunner.connector.kafka.DeserFailureHandlerType;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.util.StringUtils;

public class DeserFailureHandlerOptions {
    public static final ConfigOption<DeserFailureHandlerType> SCAN_DESER_FAILURE_HANDLER = ConfigOptions.key((String)"scan.deser-failure.handler").enumType(DeserFailureHandlerType.class).defaultValue((Object)DeserFailureHandlerType.NONE);
    public static final ConfigOption<String> SCAN_DESER_FAILURE_TOPIC = ConfigOptions.key((String)"scan.deser-failure.topic").stringType().noDefaultValue();

    public static void validateDeserFailureHandlerOptions(ReadableConfig tableOptions) {
        DeserFailureHandlerType handler = (DeserFailureHandlerType)((Object)tableOptions.get(SCAN_DESER_FAILURE_HANDLER));
        String topic = (String)tableOptions.get(SCAN_DESER_FAILURE_TOPIC);
        if (handler == DeserFailureHandlerType.KAFKA && StringUtils.isNullOrWhitespaceOnly((String)topic)) {
            throw new ValidationException(String.format("'%s' is set to '%s', but '%s' is not specified.", new Object[]{SCAN_DESER_FAILURE_HANDLER.key(), DeserFailureHandlerType.KAFKA, SCAN_DESER_FAILURE_TOPIC.key()}));
        }
        if (handler != DeserFailureHandlerType.KAFKA && !StringUtils.isNullOrWhitespaceOnly((String)topic)) {
            throw new ValidationException(String.format("'%s' is not set to '%s', but '%s' is specified.", new Object[]{SCAN_DESER_FAILURE_HANDLER.key(), DeserFailureHandlerType.KAFKA, SCAN_DESER_FAILURE_TOPIC.key()}));
        }
    }

    private DeserFailureHandlerOptions() {
    }
}

