/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.connector.kafka;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeserFailureProducer
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DeserFailureProducer.class);
    private static final long serialVersionUID = 1L;
    private final String topic;
    private final Properties producerProps;
    private transient KafkaProducer<byte[], byte[]> producer;

    DeserFailureProducer(String topic, Properties consumerProps) {
        this.topic = (String)Preconditions.checkNotNull((Object)topic);
        this.producerProps = new Properties();
        this.producerProps.putAll((Map<?, ?>)consumerProps);
        this.producerProps.setProperty("key.serializer", ByteArraySerializer.class.getName());
        this.producerProps.setProperty("value.serializer", ByteArraySerializer.class.getName());
    }

    private void init() {
        this.producer = new KafkaProducer(this.producerProps);
    }

    void send(ConsumerRecord<byte[], byte[]> record) {
        if (this.producer == null) {
            this.init();
        }
        if (record == null) {
            LOG.info("Unable to send deserialization failed record: Record was null.");
        } else {
            this.producer.send(new ProducerRecord(this.topic, null, null, (Object)((byte[])record.key()), (Object)((byte[])record.value()), (Iterable)record.headers()));
        }
    }

    public String getTopic() {
        return this.topic;
    }
}

