/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import com.datasqrl.flinkrunner.connector.kafka.DeserFailureHandler;
import com.datasqrl.flinkrunner.connector.kafka.DeserFailureHandlerOptions;
import com.google.auto.service.AutoService;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.kafka.source.KafkaSourceOptions;
import org.apache.flink.streaming.connectors.kafka.config.BoundedMode;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptionsUtil;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.streaming.connectors.kafka.table.SafeKafkaDynamicSource;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class SafeKafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SafeKafkaDynamicTableFactory.class);
    private static final ConfigOption<String> SINK_SEMANTIC = ConfigOptions.key((String)"sink.semantic").stringType().noDefaultValue().withDescription("Optional semantic when committing.");
    public static final String IDENTIFIER = "kafka-safe";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(KafkaConnectorOptions.KEY_FORMAT);
        options.add(KafkaConnectorOptions.KEY_FIELDS);
        options.add(KafkaConnectorOptions.KEY_FIELDS_PREFIX);
        options.add(KafkaConnectorOptions.VALUE_FORMAT);
        options.add(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE);
        options.add(KafkaConnectorOptions.TOPIC);
        options.add(KafkaConnectorOptions.TOPIC_PATTERN);
        options.add(KafkaConnectorOptions.PROPS_GROUP_ID);
        options.add(KafkaConnectorOptions.SCAN_STARTUP_MODE);
        options.add(KafkaConnectorOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(KafkaConnectorOptions.SCAN_TOPIC_PARTITION_DISCOVERY);
        options.add(KafkaConnectorOptions.SCAN_STARTUP_TIMESTAMP_MILLIS);
        options.add(KafkaConnectorOptions.SINK_PARTITIONER);
        options.add(KafkaConnectorOptions.SINK_PARALLELISM);
        options.add(KafkaConnectorOptions.DELIVERY_GUARANTEE);
        options.add(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX);
        options.add(SINK_SEMANTIC);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_MODE);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_SPECIFIC_OFFSETS);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_TIMESTAMP_MILLIS);
        options.add(DeserFailureHandlerOptions.SCAN_DESER_FAILURE_HANDLER);
        options.add(DeserFailureHandlerOptions.SCAN_DESER_FAILURE_TOPIC);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS, KafkaConnectorOptions.PROPS_GROUP_ID, KafkaConnectorOptions.TOPIC, KafkaConnectorOptions.TOPIC_PATTERN, KafkaConnectorOptions.SCAN_STARTUP_MODE, KafkaConnectorOptions.SCAN_STARTUP_SPECIFIC_OFFSETS, KafkaConnectorOptions.SCAN_TOPIC_PARTITION_DISCOVERY, KafkaConnectorOptions.SCAN_STARTUP_TIMESTAMP_MILLIS, KafkaConnectorOptions.SINK_PARTITIONER, KafkaConnectorOptions.SINK_PARALLELISM, KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX).collect(Collectors.toSet());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = SafeKafkaDynamicTableFactory.getKeyDecodingFormat(helper);
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = SafeKafkaDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        KafkaConnectorOptionsUtil.validateTableSourceOptions((ReadableConfig)tableOptions);
        SafeKafkaDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), context.getPrimaryKeyIndexes(), context.getCatalogTable().getOptions(), valueDecodingFormat);
        DeserFailureHandlerOptions.validateDeserFailureHandlerOptions(tableOptions);
        KafkaConnectorOptionsUtil.StartupOptions startupOptions = KafkaConnectorOptionsUtil.getStartupOptions((ReadableConfig)tableOptions);
        KafkaConnectorOptionsUtil.BoundedOptions boundedOptions = KafkaConnectorOptionsUtil.getBoundedOptions((ReadableConfig)tableOptions);
        Properties properties = KafkaConnectorOptionsUtil.getKafkaProperties((Map)context.getCatalogTable().getOptions());
        Duration partitionDiscoveryInterval = (Duration)tableOptions.get(KafkaConnectorOptions.SCAN_TOPIC_PARTITION_DISCOVERY);
        properties.setProperty(KafkaSourceOptions.PARTITION_DISCOVERY_INTERVAL_MS.key(), Long.toString(partitionDiscoveryInterval.toMillis()));
        DataType physicalDataType = context.getPhysicalRowDataType();
        int[] keyProjection = KafkaConnectorOptionsUtil.createKeyFormatProjection((ReadableConfig)tableOptions, (DataType)physicalDataType);
        int[] valueProjection = KafkaConnectorOptionsUtil.createValueFormatProjection((ReadableConfig)tableOptions, (DataType)physicalDataType);
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        DeserFailureHandler deserFailureHandler = DeserFailureHandler.of(tableOptions, properties);
        return this.createKafkaTableSource(physicalDataType, (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyDecodingFormat.orElse(null)), valueDecodingFormat, keyProjection, valueProjection, keyPrefix, KafkaConnectorOptionsUtil.getSourceTopics((ReadableConfig)tableOptions), KafkaConnectorOptionsUtil.getSourceTopicPattern((ReadableConfig)tableOptions), properties, startupOptions.startupMode, startupOptions.specificOffsets, startupOptions.startupTimestampMillis, boundedOptions.boundedMode, boundedOptions.specificOffsets, boundedOptions.boundedTimestampMillis, context.getObjectIdentifier().asSummaryString(), deserFailureHandler);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)KafkaConnectorOptionsUtil.autoCompleteSchemaRegistrySubject((DynamicTableFactory.Context)context));
        Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat = SafeKafkaDynamicTableFactory.getKeyEncodingFormat(helper);
        EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat = SafeKafkaDynamicTableFactory.getValueEncodingFormat(helper);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        DeliveryGuarantee deliveryGuarantee = SafeKafkaDynamicTableFactory.validateDeprecatedSemantic(tableOptions);
        KafkaConnectorOptionsUtil.validateTableSinkOptions((ReadableConfig)tableOptions);
        KafkaConnectorOptionsUtil.validateDeliveryGuarantee((ReadableConfig)tableOptions);
        SafeKafkaDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), context.getPrimaryKeyIndexes(), context.getCatalogTable().getOptions(), valueEncodingFormat);
        DataType physicalDataType = context.getPhysicalRowDataType();
        int[] keyProjection = KafkaConnectorOptionsUtil.createKeyFormatProjection((ReadableConfig)tableOptions, (DataType)physicalDataType);
        int[] valueProjection = KafkaConnectorOptionsUtil.createValueFormatProjection((ReadableConfig)tableOptions, (DataType)physicalDataType);
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        Integer parallelism = tableOptions.getOptional(KafkaConnectorOptions.SINK_PARALLELISM).orElse(null);
        return this.createKafkaTableSink(physicalDataType, (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyEncodingFormat.orElse(null)), valueEncodingFormat, keyProjection, valueProjection, keyPrefix, (String)((List)tableOptions.get(KafkaConnectorOptions.TOPIC)).get(0), KafkaConnectorOptionsUtil.getKafkaProperties((Map)context.getCatalogTable().getOptions()), (FlinkKafkaPartitioner<RowData>)((FlinkKafkaPartitioner)KafkaConnectorOptionsUtil.getFlinkKafkaPartitioner((ReadableConfig)tableOptions, (ClassLoader)context.getClassLoader()).orElse(null)), deliveryGuarantee, parallelism, (String)tableOptions.get(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX));
    }

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(KafkaConnectorOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    private static Optional<EncodingFormat<SerializationSchema<RowData>>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyEncodingFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        keyEncodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(KafkaConnectorOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyEncodingFormat;
    }

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT));
    }

    private static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT));
    }

    private static void validatePKConstraints(ObjectIdentifier tableName, int[] primaryKeyIndexes, Map<String, String> options, Format format) {
        if (primaryKeyIndexes.length > 0 && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            Configuration configuration = Configuration.fromMap(options);
            String formatName = configuration.getOptional(FactoryUtil.FORMAT).orElse((String)configuration.get(KafkaConnectorOptions.VALUE_FORMAT));
            throw new ValidationException(String.format("The Kafka table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), formatName));
        }
    }

    private static DeliveryGuarantee validateDeprecatedSemantic(ReadableConfig tableOptions) {
        if (tableOptions.getOptional(SINK_SEMANTIC).isPresent()) {
            LOG.warn("{} is deprecated and will be removed. Please use {} instead.", (Object)SINK_SEMANTIC.key(), (Object)KafkaConnectorOptions.DELIVERY_GUARANTEE.key());
            return DeliveryGuarantee.valueOf((String)((String)tableOptions.get(SINK_SEMANTIC)).toUpperCase().replace("-", "_"));
        }
        return (DeliveryGuarantee)tableOptions.get(KafkaConnectorOptions.DELIVERY_GUARANTEE);
    }

    protected SafeKafkaDynamicSource createKafkaTableSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis, BoundedMode boundedMode, Map<KafkaTopicPartition, Long> specificEndOffsets, long endTimestampMillis, String tableIdentifier, DeserFailureHandler deserFailureHandler) {
        return new SafeKafkaDynamicSource(physicalDataType, keyDecodingFormat, valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, properties, startupMode, specificStartupOffsets, startupTimestampMillis, boundedMode, specificEndOffsets, endTimestampMillis, false, tableIdentifier, deserFailureHandler);
    }

    protected KafkaDynamicSink createKafkaTableSink(DataType physicalDataType, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, String topic, Properties properties, FlinkKafkaPartitioner<RowData> partitioner, DeliveryGuarantee deliveryGuarantee, Integer parallelism, @Nullable String transactionalIdPrefix) {
        return new KafkaDynamicSink(physicalDataType, physicalDataType, keyEncodingFormat, valueEncodingFormat, keyProjection, valueProjection, keyPrefix, topic, properties, partitioner, deliveryGuarantee, false, SinkBufferFlushMode.DISABLED, parallelism, transactionalIdPrefix);
    }
}

