/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.commons;

import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;

@AutoService(value={AutoRegisterSystemFunction.class})
public class hash_columns
extends ScalarFunction
implements AutoRegisterSystemFunction {
    public String eval(Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        for (Object obj : objects) {
            int hash = Objects.hashCode(obj);
            digest.update(Integer.toString(hash).getBytes(StandardCharsets.UTF_8));
        }
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder(2 * hashBytes.length);
        for (byte b : hashBytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        InputTypeStrategy inputTypeStrategy = InputTypeStrategies.compositeSequence().finishWithVarying((InputTypeStrategy)InputTypeStrategies.WILDCARD);
        return TypeInference.newBuilder().inputTypeStrategy(inputTypeStrategy).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.CHAR((int)32))).build();
    }
}

