/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.ArrayAggAccumulator;
import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import java.util.LinkedList;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ValueNode;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@AutoService(value={AutoRegisterSystemFunction.class})
public class jsonb_array_agg
extends AggregateFunction<FlinkJsonType, ArrayAggAccumulator>
implements AutoRegisterSystemFunction {
    private static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public ArrayAggAccumulator createAccumulator() {
        return new ArrayAggAccumulator(new LinkedList<JsonNode>(), new LinkedList<JsonNode>());
    }

    public void accumulate(ArrayAggAccumulator acc, String value) {
        acc.add((JsonNode)mapper.getNodeFactory().textNode(value));
    }

    public void accumulate(ArrayAggAccumulator acc, FlinkJsonType value) {
        acc.add(value == null ? null : value.json);
    }

    public void accumulate(ArrayAggAccumulator acc, Double value) {
        acc.add((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void accumulate(ArrayAggAccumulator acc, Long value) {
        acc.add((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void accumulate(ArrayAggAccumulator acc, Integer value) {
        acc.add((JsonNode)mapper.getNodeFactory().numberNode(value));
    }

    public void retract(ArrayAggAccumulator acc, String value) {
        TextNode nodeVal = mapper.getNodeFactory().textNode(value);
        if (!acc.remove((JsonNode)nodeVal)) {
            acc.addRetract((JsonNode)nodeVal);
        }
    }

    public void retract(ArrayAggAccumulator acc, FlinkJsonType value) {
        JsonNode finalVal;
        JsonNode jsonNode = finalVal = value == null ? null : value.json;
        if (!acc.remove(finalVal)) {
            acc.addRetract(finalVal);
        }
    }

    public void retract(ArrayAggAccumulator acc, Double value) {
        ValueNode nodeVal = mapper.getNodeFactory().numberNode(value);
        if (!acc.getElements().remove(nodeVal)) {
            acc.addRetract((JsonNode)nodeVal);
        }
    }

    public void retract(ArrayAggAccumulator acc, Long value) {
        ValueNode nodeVal = mapper.getNodeFactory().numberNode(value);
        if (!acc.getElements().remove(nodeVal)) {
            acc.addRetract((JsonNode)nodeVal);
        }
    }

    public void retract(ArrayAggAccumulator acc, Integer value) {
        ValueNode nodeVal = mapper.getNodeFactory().numberNode(value);
        if (!acc.getElements().remove(nodeVal)) {
            acc.addRetract((JsonNode)nodeVal);
        }
    }

    public void merge(ArrayAggAccumulator acc, Iterable<ArrayAggAccumulator> iterable) {
        for (ArrayAggAccumulator otherAcc : iterable) {
            acc.getElements().addAll(otherAcc.getElements());
            acc.getRetractElements().addAll(otherAcc.getRetractElements());
        }
        LinkedList<JsonNode> newRetractBuffer = new LinkedList<JsonNode>();
        for (JsonNode elem : acc.getRetractElements()) {
            if (acc.remove(elem)) continue;
            newRetractBuffer.add(elem);
        }
        acc.getRetractElements().clear();
        acc.getRetractElements().addAll(newRetractBuffer);
    }

    public FlinkJsonType getValue(ArrayAggAccumulator acc) {
        ArrayNode arrayNode = mapper.createArrayNode();
        for (Object e : acc.getElements()) {
            if (e instanceof FlinkJsonType) {
                arrayNode.add(((FlinkJsonType)e).json);
                continue;
            }
            arrayNode.addPOJO(e);
        }
        return new FlinkJsonType((JsonNode)arrayNode);
    }
}

