/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.json;

import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonType;
import com.datasqrl.flinkrunner.stdlib.json.FlinkJsonTypeSerializer;
import com.datasqrl.flinkrunner.stdlib.json.ObjectAggAccumulator;
import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.google.auto.service.AutoService;
import java.util.LinkedHashMap;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@FunctionHint(output=@DataTypeHint(value="RAW", bridgedTo=FlinkJsonType.class, rawSerializer=FlinkJsonTypeSerializer.class))
@AutoService(value={AutoRegisterSystemFunction.class})
public class jsonb_object_agg
extends AggregateFunction<Object, ObjectAggAccumulator>
implements AutoRegisterSystemFunction {
    private static final ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();

    public ObjectAggAccumulator createAccumulator() {
        return new ObjectAggAccumulator(new LinkedHashMap<String, JsonNode>());
    }

    public void accumulate(ObjectAggAccumulator accumulator, String key, String value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAggAccumulator accumulator, String key, @DataTypeHint(inputGroup=InputGroup.ANY) Object value) {
        if (value instanceof FlinkJsonType) {
            this.accumulateObject(accumulator, key, ((FlinkJsonType)value).getJson());
        } else {
            accumulator.add(key, (JsonNode)mapper.getNodeFactory().pojoNode(value));
        }
    }

    public void accumulate(ObjectAggAccumulator accumulator, String key, Double value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAggAccumulator accumulator, String key, Long value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulate(ObjectAggAccumulator accumulator, String key, Integer value) {
        this.accumulateObject(accumulator, key, value);
    }

    public void accumulateObject(ObjectAggAccumulator accumulator, String key, Object value) {
        accumulator.add(key, (JsonNode)mapper.getNodeFactory().pojoNode(value));
    }

    public void retract(ObjectAggAccumulator accumulator, String key, String value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAggAccumulator accumulator, String key, @DataTypeHint(inputGroup=InputGroup.ANY) Object value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAggAccumulator accumulator, String key, Double value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAggAccumulator accumulator, String key, Long value) {
        this.retractObject(accumulator, key);
    }

    public void retract(ObjectAggAccumulator accumulator, String key, Integer value) {
        this.retractObject(accumulator, key);
    }

    public void retractObject(ObjectAggAccumulator accumulator, String key) {
        accumulator.remove(key);
    }

    public void merge(ObjectAggAccumulator accumulator, Iterable<ObjectAggAccumulator> iterable) {
        iterable.forEach(o -> accumulator.getObjects().putAll(o.getObjects()));
    }

    public FlinkJsonType getValue(ObjectAggAccumulator accumulator) {
        ObjectNode objectNode = mapper.createObjectNode();
        accumulator.getObjects().forEach((arg_0, arg_1) -> ((ObjectNode)objectNode).putPOJO(arg_0, arg_1));
        return new FlinkJsonType((JsonNode)objectNode);
    }
}

