/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai;

import com.datasqrl.flinkrunner.stdlib.openai.OpenAiCompletions;
import com.datasqrl.flinkrunner.stdlib.openai.utils.FunctionExecutor;
import com.google.auto.service.AutoService;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;

@AutoService(value={ScalarFunction.class})
public class completions
extends ScalarFunction {
    private transient OpenAiCompletions openAiCompletions;
    private transient FunctionExecutor executor;

    public void open(FunctionContext context) throws Exception {
        this.openAiCompletions = this.createOpenAICompletions();
        this.executor = new FunctionExecutor(context, completions.class.getSimpleName());
    }

    protected OpenAiCompletions createOpenAICompletions() {
        return new OpenAiCompletions();
    }

    public String eval(String prompt, String modelName) {
        return this.eval(prompt, modelName, null, null, null);
    }

    public String eval(String prompt, String modelName, Integer maxOutputTokens) {
        return this.eval(prompt, modelName, maxOutputTokens, null, null);
    }

    public String eval(String prompt, String modelName, Integer maxOutputTokens, Double temperature) {
        return this.eval(prompt, modelName, maxOutputTokens, temperature, null);
    }

    public String eval(String prompt, String modelName, Integer maxOutputTokens, Double temperature, Double topP) {
        OpenAiCompletions.CompletionsRequest request = OpenAiCompletions.CompletionsRequest.builder().prompt(prompt).modelName(modelName).maxOutputTokens(maxOutputTokens).temperature(temperature).topP(topP).build();
        return this.executor.execute(() -> this.openAiCompletions.callCompletions(request));
    }
}

