/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai;

import com.datasqrl.flinkrunner.stdlib.openai.OpenAiCompletions;
import com.datasqrl.flinkrunner.stdlib.openai.utils.FunctionExecutor;
import com.google.auto.service.AutoService;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;

@AutoService(value={ScalarFunction.class})
public class extract_json
extends ScalarFunction {
    private transient OpenAiCompletions openAiCompletions;
    private transient FunctionExecutor executor;

    public void open(FunctionContext context) throws Exception {
        this.openAiCompletions = this.createOpenAiCompletions();
        this.executor = new FunctionExecutor(context, extract_json.class.getSimpleName());
    }

    protected OpenAiCompletions createOpenAiCompletions() {
        return new OpenAiCompletions();
    }

    public String eval(String prompt, String modelName) {
        return this.eval(prompt, modelName, null);
    }

    public String eval(String prompt, String modelName, Double temperature) {
        return this.eval(prompt, modelName, temperature, null);
    }

    public String eval(String prompt, String modelName, Double temperature, Double topP) {
        return this.eval(prompt, modelName, temperature, topP, null);
    }

    public String eval(String prompt, String modelName, Double temperature, Double topP, String jsonSchema) {
        OpenAiCompletions.CompletionsRequest request = OpenAiCompletions.CompletionsRequest.builder().prompt(prompt).modelName(modelName).requireJsonOutput(true).jsonSchema(jsonSchema).temperature(temperature).topP(topP).build();
        return this.executor.execute(() -> this.openAiCompletions.callCompletions(request));
    }
}

