/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai.utils;

import com.datasqrl.flinkrunner.stdlib.openai.utils.P99LatencyTracker;
import org.apache.flink.metrics.Counter;
import org.apache.flink.table.functions.FunctionContext;

public class FunctionMetricTracker {
    public static final String P99_METRIC = "com.datasqrl.openai.%s.p99";
    public static final String CALL_COUNT = "com.datasqrl.openai.%s.callCount";
    public static final String ERROR_COUNT = "com.datasqrl.openai.%s.errorCount";
    private final P99LatencyTracker latencyTracker = new P99LatencyTracker();
    private final Counter callCount;
    private final Counter errorCount;

    public FunctionMetricTracker(FunctionContext context, String functionName) {
        String p99MetricName = String.format(P99_METRIC, functionName);
        String callCountName = String.format(CALL_COUNT, functionName);
        String errorCountName = String.format(ERROR_COUNT, functionName);
        context.getMetricGroup().gauge(p99MetricName, this.latencyTracker::getP99Latency);
        this.callCount = context.getMetricGroup().counter(callCountName);
        this.errorCount = context.getMetricGroup().counter(errorCountName);
    }

    public void increaseCallCount() {
        this.callCount.inc();
    }

    public void increaseErrorCount() {
        this.errorCount.inc();
    }

    public void recordLatency(long latencyMs) {
        this.latencyTracker.recordLatency(latencyMs);
    }
}

