/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class P99LatencyTracker {
    private static final int DEFAULT_MAX_SIZE = 100;
    private final List<Long> latencies;
    private final int maxSize;

    public P99LatencyTracker() {
        this(100);
    }

    public P99LatencyTracker(int maxSize) {
        this.maxSize = maxSize;
        this.latencies = new ArrayList<Long>();
    }

    public void recordLatency(long latencyMs) {
        this.latencies.add(latencyMs);
        if (this.latencies.size() > this.maxSize) {
            this.latencies.remove(0);
        }
    }

    public Long getP99Latency() {
        if (this.latencies.isEmpty()) {
            return 0L;
        }
        Collections.sort(this.latencies);
        int index = (int)Math.ceil(0.99 * (double)this.latencies.size()) - 1;
        return this.latencies.get(index);
    }
}

