/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai;

import com.datasqrl.flinkrunner.stdlib.openai.OpenAiEmbeddings;
import com.datasqrl.flinkrunner.stdlib.openai.utils.FunctionExecutor;
import com.datasqrl.flinkrunner.stdlib.vector.FlinkVectorType;
import com.google.auto.service.AutoService;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;

@AutoService(value={ScalarFunction.class})
public class vector_embed
extends ScalarFunction {
    private transient OpenAiEmbeddings openAiEmbeddings;
    private transient FunctionExecutor executor;

    public void open(FunctionContext context) throws Exception {
        this.openAiEmbeddings = this.createOpenAiEmbeddings();
        this.executor = new FunctionExecutor(context, vector_embed.class.getSimpleName());
    }

    protected OpenAiEmbeddings createOpenAiEmbeddings() {
        return new OpenAiEmbeddings();
    }

    public FlinkVectorType eval(String text, String modelName) {
        return this.executor.execute(() -> this.openAiEmbeddings.vectorEmbed(text, modelName));
    }
}

