/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai_async;

import com.datasqrl.flinkrunner.stdlib.openai.OpenAiCompletions;
import com.datasqrl.flinkrunner.stdlib.openai.utils.FunctionExecutor;
import com.google.auto.service.AutoService;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.table.functions.AsyncScalarFunction;
import org.apache.flink.table.functions.FunctionContext;

@AutoService(value={AsyncScalarFunction.class})
public class completions
extends AsyncScalarFunction {
    private transient OpenAiCompletions openAiCompletions;
    private transient FunctionExecutor executor;

    public void open(FunctionContext context) throws Exception {
        this.openAiCompletions = this.createOpenAICompletions();
        this.executor = new FunctionExecutor(context, completions.class.getSimpleName());
    }

    protected OpenAiCompletions createOpenAICompletions() {
        return new OpenAiCompletions();
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName) {
        this.eval(result, prompt, modelName, null, null, null);
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName, Integer maxOutputTokens) {
        this.eval(result, prompt, modelName, maxOutputTokens, null, null);
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName, Integer maxOutputTokens, Double temperature) {
        this.eval(result, prompt, modelName, maxOutputTokens, temperature, null);
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName, Integer maxOutputTokens, Double temperature, Double topP) {
        OpenAiCompletions.CompletionsRequest request = OpenAiCompletions.CompletionsRequest.builder().prompt(prompt).modelName(modelName).maxOutputTokens(maxOutputTokens).temperature(temperature).topP(topP).build();
        this.executor.execute(() -> this.openAiCompletions.callCompletions(request), result);
    }
}

