/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai_async;

import com.datasqrl.flinkrunner.stdlib.openai.OpenAiCompletions;
import com.datasqrl.flinkrunner.stdlib.openai.utils.FunctionExecutor;
import com.google.auto.service.AutoService;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.table.functions.AsyncScalarFunction;
import org.apache.flink.table.functions.FunctionContext;

@AutoService(value={AsyncScalarFunction.class})
public class extract_json
extends AsyncScalarFunction {
    private transient OpenAiCompletions openAiCompletions;
    private transient FunctionExecutor executor;

    public void open(FunctionContext context) throws Exception {
        this.openAiCompletions = this.createOpenAiCompletions();
        this.executor = new FunctionExecutor(context, extract_json.class.getSimpleName());
    }

    protected OpenAiCompletions createOpenAiCompletions() {
        return new OpenAiCompletions();
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName) {
        this.eval(result, prompt, modelName, null);
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName, Double temperature) {
        this.eval(result, prompt, modelName, temperature, null);
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName, Double temperature, Double topP) {
        this.eval(result, prompt, modelName, temperature, topP, null);
    }

    public void eval(CompletableFuture<String> result, String prompt, String modelName, Double temperature, Double topP, String jsonSchema) {
        OpenAiCompletions.CompletionsRequest request = OpenAiCompletions.CompletionsRequest.builder().prompt(prompt).modelName(modelName).requireJsonOutput(true).jsonSchema(jsonSchema).temperature(temperature).topP(topP).build();
        this.executor.execute(() -> this.openAiCompletions.callCompletions(request), result);
    }
}

