/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.openai_async;

import com.datasqrl.flinkrunner.stdlib.openai.OpenAiEmbeddings;
import com.datasqrl.flinkrunner.stdlib.openai.utils.FunctionExecutor;
import com.datasqrl.flinkrunner.stdlib.vector.FlinkVectorType;
import com.google.auto.service.AutoService;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.table.functions.AsyncScalarFunction;
import org.apache.flink.table.functions.FunctionContext;

@AutoService(value={AsyncScalarFunction.class})
public class vector_embed
extends AsyncScalarFunction {
    private transient OpenAiEmbeddings openAiEmbeddings;
    private transient FunctionExecutor executor;

    public void open(FunctionContext context) throws Exception {
        this.openAiEmbeddings = this.createOpenAiEmbeddings();
        this.executor = new FunctionExecutor(context, vector_embed.class.getSimpleName());
    }

    protected OpenAiEmbeddings createOpenAiEmbeddings() {
        return new OpenAiEmbeddings();
    }

    public void eval(CompletableFuture<FlinkVectorType> result, String text, String modelName) {
        this.executor.execute(() -> this.openAiEmbeddings.vectorEmbed(text, modelName), result);
    }
}

