/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.AdaptedCallContext;

public class FlinkTypeUtil {
    public static TypeStrategy nullPreservingOutputStrategy(DataType outputType) {
        return callContext -> {
            DataType type = FlinkTypeUtil.getFirstArgumentType(callContext);
            if (type.getLogicalType().isNullable()) {
                return Optional.of((DataType)outputType.nullable());
            }
            return Optional.of((DataType)outputType.notNull());
        };
    }

    public static TypeInference basicNullInference(DataType outputType, DataType inputType) {
        return TypeInference.newBuilder().typedArguments(new DataType[]{inputType}).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy(outputType)).build();
    }

    public static TypeInference.Builder basicNullInferenceBuilder(DataType outputType, DataType inputType) {
        return TypeInference.newBuilder().typedArguments(new DataType[]{inputType}).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy(outputType));
    }

    public static DataType getFirstArgumentType(CallContext callContext) {
        if (callContext instanceof AdaptedCallContext) {
            Field privateField = AdaptedCallContext.class.getDeclaredField("originalContext");
            privateField.setAccessible(true);
            CallContext originalContext = (CallContext)privateField.get(callContext);
            return (DataType)originalContext.getArgumentDataTypes().get(0);
        }
        return (DataType)callContext.getArgumentDataTypes().get(0);
    }

    public static final class VariableArguments
    implements InputTypeStrategy {
        private final List<DataType> staticTypes;
        private final DataType variableType;
        private final int minVariableArguments;
        private final int maxVariableArguments;

        public ArgumentCount getArgumentCount() {
            return new ArgumentCount(){

                public boolean isValidCount(int count) {
                    int variableCount = count - staticTypes.size();
                    return variableCount >= minVariableArguments && variableCount <= maxVariableArguments;
                }

                public Optional<Integer> getMinCount() {
                    return Optional.of(staticTypes.size() + minVariableArguments);
                }

                public Optional<Integer> getMaxCount() {
                    return Optional.of(staticTypes.size() + maxVariableArguments);
                }
            };
        }

        public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
            int argCount = callContext.getArgumentDataTypes().size();
            int varArgs = argCount - this.staticTypes.size();
            if (varArgs < 0 || varArgs < this.minVariableArguments || varArgs > this.maxVariableArguments) {
                return Optional.empty();
            }
            ArrayList<DataType> result = new ArrayList<DataType>(argCount);
            result.addAll(this.staticTypes);
            for (int i = 0; i < varArgs; ++i) {
                result.add(this.variableType);
            }
            return Optional.of(result);
        }

        public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
            ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>(this.staticTypes.size() + 1);
            this.staticTypes.stream().map(DataType::toString).map(Signature.Argument::of).forEach(arguments::add);
            arguments.add(Signature.Argument.of((String)(this.variableType.toString() + "...")));
            return List.of(Signature.of(arguments));
        }

        @Generated
        VariableArguments(List<DataType> staticTypes, DataType variableType, int minVariableArguments, int maxVariableArguments) {
            this.staticTypes = staticTypes;
            this.variableType = variableType;
            this.minVariableArguments = minVariableArguments;
            this.maxVariableArguments = maxVariableArguments;
        }

        @Generated
        public static VariableArgumentsBuilder builder() {
            return new VariableArgumentsBuilder();
        }

        @Generated
        public List<DataType> getStaticTypes() {
            return this.staticTypes;
        }

        @Generated
        public DataType getVariableType() {
            return this.variableType;
        }

        @Generated
        public int getMinVariableArguments() {
            return this.minVariableArguments;
        }

        @Generated
        public int getMaxVariableArguments() {
            return this.maxVariableArguments;
        }

        @Generated
        public static class VariableArgumentsBuilder {
            @Generated
            private ArrayList<DataType> staticTypes;
            @Generated
            private DataType variableType;
            @Generated
            private int minVariableArguments;
            @Generated
            private int maxVariableArguments;

            @Generated
            VariableArgumentsBuilder() {
            }

            @Generated
            public VariableArgumentsBuilder staticType(DataType staticType) {
                if (this.staticTypes == null) {
                    this.staticTypes = new ArrayList();
                }
                this.staticTypes.add(staticType);
                return this;
            }

            @Generated
            public VariableArgumentsBuilder staticTypes(Collection<? extends DataType> staticTypes) {
                if (staticTypes == null) {
                    throw new NullPointerException("staticTypes cannot be null");
                }
                if (this.staticTypes == null) {
                    this.staticTypes = new ArrayList();
                }
                this.staticTypes.addAll(staticTypes);
                return this;
            }

            @Generated
            public VariableArgumentsBuilder clearStaticTypes() {
                if (this.staticTypes != null) {
                    this.staticTypes.clear();
                }
                return this;
            }

            @Generated
            public VariableArgumentsBuilder variableType(DataType variableType) {
                this.variableType = variableType;
                return this;
            }

            @Generated
            public VariableArgumentsBuilder minVariableArguments(int minVariableArguments) {
                this.minVariableArguments = minVariableArguments;
                return this;
            }

            @Generated
            public VariableArgumentsBuilder maxVariableArguments(int maxVariableArguments) {
                this.maxVariableArguments = maxVariableArguments;
                return this;
            }

            @Generated
            public VariableArguments build() {
                List<DataType> staticTypes;
                switch (this.staticTypes == null ? 0 : this.staticTypes.size()) {
                    case 0: {
                        staticTypes = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        staticTypes = Collections.singletonList(this.staticTypes.get(0));
                        break;
                    }
                    default: {
                        staticTypes = Collections.unmodifiableList(new ArrayList<DataType>(this.staticTypes));
                    }
                }
                return new VariableArguments(staticTypes, this.variableType, this.minVariableArguments, this.maxVariableArguments);
            }

            @Generated
            public String toString() {
                return "FlinkTypeUtil.VariableArguments.VariableArgumentsBuilder(staticTypes=" + String.valueOf(this.staticTypes) + ", variableType=" + String.valueOf(this.variableType) + ", minVariableArguments=" + this.minVariableArguments + ", maxVariableArguments=" + this.maxVariableArguments + ")";
            }
        }
    }
}

