/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.vector;

public class CenterAccumulator {
    public double[] sum = null;
    public int count = 0;

    public synchronized void add(double[] values) {
        if (this.count == 0) {
            this.sum = (double[])values.clone();
            this.count = 1;
        } else {
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + values[i];
            }
            ++this.count;
        }
    }

    public synchronized void addAll(CenterAccumulator other) {
        if (other.count == 0) {
            return;
        }
        if (this.count == 0) {
            this.sum = new double[other.sum.length];
        }
        for (int i = 0; i < other.sum.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] + other.sum[i];
        }
        this.count += other.count;
    }

    public double[] get() {
        double[] result = new double[this.sum.length];
        for (int i = 0; i < this.sum.length; ++i) {
            result[i] = this.sum[i] / (double)this.count;
        }
        return result;
    }

    public synchronized void substract(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] - values[i];
        }
        --this.count;
    }
}

