/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.vector;

import com.datasqrl.flinkrunner.stdlib.vector.FlinkVectorType;
import com.datasqrl.flinkrunner.stdlib.vector.FlinkVectorTypeSerializerSnapshot;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class FlinkVectorTypeSerializer
extends TypeSerializer<FlinkVectorType> {
    private static final long serialVersionUID = -8481213829625869500L;

    public boolean isImmutableType() {
        return true;
    }

    public FlinkVectorType createInstance() {
        return new FlinkVectorType(null);
    }

    public FlinkVectorType copy(FlinkVectorType from) {
        return new FlinkVectorType(from.getValue());
    }

    public FlinkVectorType copy(FlinkVectorType from, FlinkVectorType reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(FlinkVectorType record, DataOutputView target) throws IOException {
        target.writeInt(record.getValue().length);
        for (double v : record.getValue()) {
            target.writeDouble(v);
        }
    }

    public FlinkVectorType deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = source.readDouble();
        }
        return new FlinkVectorType(array);
    }

    public FlinkVectorType deserialize(FlinkVectorType reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeUTF(source.readUTF());
    }

    public TypeSerializer<FlinkVectorType> duplicate() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof FlinkVectorTypeSerializer;
    }

    public int hashCode() {
        return FlinkVectorTypeSerializer.class.hashCode();
    }

    public TypeSerializerSnapshot<FlinkVectorType> snapshotConfiguration() {
        return new FlinkVectorTypeSerializerSnapshot();
    }
}

