/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.flinkrunner.stdlib.vector;

import com.datasqrl.flinkrunner.stdlib.utils.AutoRegisterSystemFunction;
import com.datasqrl.flinkrunner.stdlib.vector.FlinkVectorType;
import com.datasqrl.flinkrunner.stdlib.vector.VectorFunctions;
import com.google.auto.service.AutoService;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.flink.table.functions.ScalarFunction;

@AutoService(value={AutoRegisterSystemFunction.class})
public class cosine_similarity
extends ScalarFunction
implements AutoRegisterSystemFunction {
    private static final long serialVersionUID = -2874221094617590631L;

    public Double eval(FlinkVectorType vectorA, FlinkVectorType vectorB) {
        if (vectorA == null || vectorB == null) {
            return null;
        }
        ArrayRealVector vA = new ArrayRealVector(VectorFunctions.VECTOR_TO_DOUBLE.eval(vectorA), false);
        ArrayRealVector vB = new ArrayRealVector(VectorFunctions.VECTOR_TO_DOUBLE.eval(vectorB), false);
        double dotProduct = vA.dotProduct((RealVector)vB);
        double normalization = vA.getNorm() * vB.getNorm();
        return dotProduct / normalization;
    }
}

