/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.dtsx.astra.sdk.cassio.AbstractCassandraTable;
import com.dtsx.astra.sdk.cassio.ClusteredRecord;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredTable
extends AbstractCassandraTable<ClusteredRecord> {
    private static final Logger log = LoggerFactory.getLogger(ClusteredTable.class);
    private PreparedStatement findPartitionStatement;
    private PreparedStatement deletePartitionStatement;
    private PreparedStatement deleteRowStatement;
    private PreparedStatement insertRowStatement;
    private PreparedStatement findRowStatement;

    public ClusteredTable(@NonNull CqlSession session, @NonNull String keyspaceName, @NonNull String tableName) {
        super(session, keyspaceName, tableName);
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keyspaceName == null) {
            throw new NullPointerException("keyspaceName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
    }

    private synchronized void prepareStatements() {
        if (this.findPartitionStatement == null) {
            this.findPartitionStatement = this.cqlSession.prepare("select * from " + this.keyspaceName + "." + this.tableName + " where partition_id = ? ");
            this.deletePartitionStatement = this.cqlSession.prepare("delete from " + this.keyspaceName + "." + this.tableName + " where partition_id = ? ");
            this.findRowStatement = this.cqlSession.prepare("select * from " + this.keyspaceName + "." + this.tableName + " where partition_id = ?  and row_id = ? ");
            this.deleteRowStatement = this.cqlSession.prepare("delete from " + this.keyspaceName + "." + this.tableName + " where partition_id = ?  and row_id = ? ");
            this.insertRowStatement = this.cqlSession.prepare("insert into " + this.keyspaceName + "." + this.tableName + " (partition_id, row_id, body_blob)  values (?, ?, ?)");
        }
    }

    @Override
    public void create() {
        this.cqlSession.execute("CREATE TABLE IF NOT EXISTS " + this.keyspaceName + "." + this.tableName + " (partition_id text, row_id timeuuid, body_blob text, PRIMARY KEY ((partition_id), row_id)) WITH CLUSTERING ORDER BY (row_id DESC)");
        log.info("+ Table '{}' has been created (if needed).", (Object)this.tableName);
    }

    @Override
    public void put(@NonNull ClusteredRecord row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        this.prepareStatements();
        this.cqlSession.execute((Statement)this.insertRowStatement.bind(new Object[]{row.getPartitionId(), row.getRowId(), row.getBody()}));
    }

    @Override
    public ClusteredRecord mapRow(@NonNull Row row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        return new ClusteredRecord(row.getString("partition_id"), row.getUuid("row_id"), row.getString("body_blob"));
    }

    public List<ClusteredRecord> findPartition(@NonNull String partitionDd) {
        if (partitionDd == null) {
            throw new NullPointerException("partitionDd is marked non-null but is null");
        }
        this.prepareStatements();
        return this.cqlSession.execute((Statement)this.findPartitionStatement.bind(new Object[]{partitionDd})).all().stream().map(this::mapRow).collect(Collectors.toList());
    }

    public void upsertPartition(List<ClusteredRecord> rows) {
        this.prepareStatements();
        if (rows != null && !rows.isEmpty()) {
            BatchStatementBuilder batch = BatchStatement.builder((BatchType)BatchType.LOGGED);
            String currentPartitionId = null;
            for (ClusteredRecord row : rows) {
                if (currentPartitionId != null && !currentPartitionId.equals(row.getPartitionId())) {
                    log.warn("Not all rows are part of the same partition");
                }
                currentPartitionId = row.getPartitionId();
                batch.addStatement((BatchableStatement)this.insertRowStatement.bind(new Object[]{row.getPartitionId(), row.getRowId(), row.getBody()}));
            }
            this.cqlSession.execute((Statement)batch.build());
        }
    }

    public Optional<ClusteredRecord> findById(String partition, UUID rowId) {
        this.prepareStatements();
        return Optional.ofNullable((Row)this.cqlSession.execute((Statement)this.findRowStatement.bind(new Object[]{partition, rowId})).one()).map(this::mapRow);
    }

    public void deletePartition(@NonNull String partitionId) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        this.prepareStatements();
        this.cqlSession.execute((Statement)this.deletePartitionStatement.bind(new Object[]{partitionId}));
    }

    public void delete(@NonNull String partitionId, @NonNull UUID rowId) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        this.prepareStatements();
        this.cqlSession.execute((Statement)this.deleteRowStatement.bind(new Object[]{partitionId, rowId}));
    }

    public void insert(@NonNull String partitionId, @NonNull UUID rowId, @NonNull String bodyBlob) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        if (bodyBlob == null) {
            throw new NullPointerException("bodyBlob is marked non-null but is null");
        }
        this.prepareStatements();
        this.cqlSession.execute((Statement)this.insertRowStatement.bind(new Object[]{partitionId, rowId, bodyBlob}));
    }
}

