/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DbAccessListsClient;
import com.dtsx.astra.sdk.db.DbCdcsClient;
import com.dtsx.astra.sdk.db.DbDatacentersClient;
import com.dtsx.astra.sdk.db.DbKeyspacesClient;
import com.dtsx.astra.sdk.db.DbPrivateLinksClient;
import com.dtsx.astra.sdk.db.DbTelemetryClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.DatabaseStatusType;
import com.dtsx.astra.sdk.db.domain.Datacenter;
import com.dtsx.astra.sdk.db.exception.DatabaseNotFoundException;
import com.dtsx.astra.sdk.db.exception.RegionNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.dtsx.astra.sdk.utils.Utils;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClient
extends AbstractApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseClient.class);
    private final String databaseId;

    public DatabaseClient(String token, String databaseId) {
        this(token, AstraEnvironment.PROD, databaseId);
    }

    public DatabaseClient(String token, AstraEnvironment env, String databaseId) {
        super(token, env);
        Assert.hasLength(databaseId, "databaseId");
        this.databaseId = databaseId;
    }

    public Optional<Database> find() {
        ApiResponseHttp res = this.GET(this.getEndpointDatabase());
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.of(JsonUtils.unmarshallBean(res.getBody(), Database.class));
    }

    public Database get() {
        return this.find().orElseThrow(() -> new DatabaseNotFoundException(this.databaseId));
    }

    public boolean exist() {
        return this.find().isPresent();
    }

    public boolean isActive() {
        return DatabaseStatusType.ACTIVE == this.get().getStatus();
    }

    public byte[] downloadDefaultSecureConnectBundle() {
        return Utils.downloadFile(this.getDefaultSecureConnectBundleUrl());
    }

    public void downloadDefaultSecureConnectBundle(String destination) {
        Assert.hasLength(destination, "destination");
        Utils.downloadFile(this.getDefaultSecureConnectBundleUrl(), destination);
    }

    private String getDefaultSecureConnectBundleUrl() {
        if (!this.isActive()) {
            throw new IllegalStateException("Database '" + this.databaseId + "' is not available.");
        }
        ApiResponseHttp res = this.POST(this.getEndpointDatabase() + "/secureBundleURL");
        return (String)JsonUtils.unmarshallBean(res.getBody(), Map.class).get("downloadURL");
    }

    public byte[] downloadSecureConnectBundle(String region) {
        Assert.hasLength(region, "region");
        Database db = this.get();
        return this.downloadSecureConnectBundle(db.getInfo().getDatacenters().stream().filter(d -> region.equalsIgnoreCase(d.getRegion())).findFirst().orElseThrow(() -> new RegionNotFoundException(region, this.databaseId)));
    }

    public void downloadSecureConnectBundle(String region, String destination) {
        Assert.hasLength(region, "region");
        Assert.hasLength(destination, "destination");
        Database db = this.get();
        this.downloadSecureConnectBundle(db.getInfo().getDatacenters().stream().filter(d -> region.equalsIgnoreCase(d.getRegion())).findFirst().orElseThrow(() -> new RegionNotFoundException(region, this.databaseId)), destination);
    }

    private byte[] downloadSecureConnectBundle(Datacenter dc) {
        return Utils.downloadFile(dc.getSecureBundleUrl());
    }

    private void downloadSecureConnectBundle(Datacenter dc, String destination) {
        Assert.hasLength(destination, "destination");
        if (!new File(destination).exists()) {
            Utils.downloadFile(dc.getSecureBundleUrl(), destination);
            LOGGER.info("+ Downloading SCB to : {}", (Object)destination);
        } else {
            LOGGER.debug("+ SCB already available ({}) ", (Object)destination);
        }
    }

    public void downloadAllSecureConnectBundles(String destination) {
        Assert.hasLength(destination, "destination");
        Assert.isTrue(new File(destination).exists(), "Destination folder");
        Database db = this.get();
        db.getInfo().getDatacenters().forEach(dc -> this.downloadSecureConnectBundle((Datacenter)dc, destination + File.separator + this.buildScbFileName(db.getId(), dc.getRegion())));
    }

    public String buildScbFileName(String dId, String dbRegion) {
        return "scb_" + dId + "_" + dbRegion + ".zip";
    }

    public void park() {
        ApiResponseHttp res = this.POST(this.getEndpointDatabase() + "/park");
        this.assertHttpCodeAccepted(res, "park", this.databaseId);
    }

    public void unpark() {
        ApiResponseHttp res = this.POST(this.getEndpointDatabase() + "/unpark");
        this.assertHttpCodeAccepted(res, "unpark", this.databaseId);
    }

    public void delete() {
        ApiResponseHttp res = this.POST(this.getEndpointDatabase() + "/terminate");
        this.assertHttpCodeAccepted(res, "terminate", this.databaseId);
    }

    public void resize(int capacityUnits) {
        Assert.isTrue(capacityUnits > 0, "Capacity Unit");
        String body = "{ \"capacityUnits\":" + capacityUnits + "}";
        ApiResponseHttp res = this.POST(this.getEndpointDatabase() + "/resize", body);
        this.assertHttpCodeAccepted(res, "resize", this.databaseId);
    }

    public void resetPassword(String username, String password) {
        Assert.hasLength(username, "username");
        Assert.hasLength(password, "password");
        String body = "{\"username\": \"" + username + "\", \"password\": \"" + password + "\"  }";
        ApiResponseHttp res = this.POST(this.getEndpointDatabase() + "/resetPassword", body);
        this.assertHttpCodeAccepted(res, "resetPassword", this.databaseId);
    }

    public DbKeyspacesClient keyspaces() {
        return new DbKeyspacesClient(this.token, this.environment, this.databaseId);
    }

    public DbDatacentersClient datacenters() {
        return new DbDatacentersClient(this.token, this.environment, this.databaseId);
    }

    public DbAccessListsClient accessLists() {
        return new DbAccessListsClient(this.token, this.environment, this.databaseId);
    }

    public DbCdcsClient cdc() {
        return new DbCdcsClient(this.token, this.environment, this.databaseId);
    }

    public DbTelemetryClient telemetry() {
        return new DbTelemetryClient(this.token, this.environment, this.databaseId);
    }

    public DbPrivateLinksClient privateLink() {
        return new DbPrivateLinksClient(this.token, this.environment, this.databaseId);
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getEndpointDatabase() {
        return this.getEndpointDatabase(this.databaseId);
    }

    public String getEndpointDatabase(String dbId) {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/databases/" + dbId;
    }
}

