/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DatabaseClient;
import com.dtsx.astra.sdk.db.domain.AccessList;
import com.dtsx.astra.sdk.db.domain.AccessListAddress;
import com.dtsx.astra.sdk.db.domain.AccessListAddressRequest;
import com.dtsx.astra.sdk.db.domain.AccessListRequest;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class DbAccessListsClient
extends AbstractApiClient {
    private final Database db;

    public DbAccessListsClient(String token, String databaseId) {
        this(token, AstraEnvironment.PROD, databaseId);
    }

    public DbAccessListsClient(String token, AstraEnvironment env, String databaseId) {
        super(token, env);
        Assert.hasLength(databaseId, "databaseId");
        this.db = new DatabaseClient(token, databaseId).get();
    }

    public AccessList get() {
        try {
            return JsonUtils.unmarshallBean(this.GET(this.getApiDevopsEndpointAccessListsDb()).getBody(), AccessList.class);
        }
        catch (RuntimeException mex) {
            AccessList ac = new AccessList();
            ac.setDatabaseId(this.db.getId());
            ac.setOrganizationId(this.db.getOrgId());
            ac.setAddresses(new ArrayList<AccessListAddress>());
            ac.setConfigurations(new AccessList.Configurations(false));
            return ac;
        }
    }

    public void addAddress(AccessListAddressRequest ... newAddressed) {
        Assert.notNull(newAddressed, "New addresses should not be null");
        Assert.isTrue(newAddressed.length > 0, "New address should not be empty");
        this.POST(this.getApiDevopsEndpointAccessListsDb(), JsonUtils.marshall(newAddressed));
    }

    public void delete() {
        this.DELETE(this.getApiDevopsEndpointAccessListsDb());
    }

    public void replaceAddresses(AccessListAddressRequest ... addresses) {
        Assert.notNull(addresses, "Addresses should not be null");
        Assert.isTrue(addresses.length > 0, "Address should not be empty");
        this.PUT(this.getApiDevopsEndpointAccessListsDb(), JsonUtils.marshall(addresses));
    }

    public void update(AccessListAddressRequest ... addresses) {
        Assert.notNull(addresses, "Addresses should not be null");
        Assert.isTrue(addresses.length > 0, "Address should not be empty");
        AccessListRequest alr = new AccessListRequest();
        alr.setAddresses(Arrays.asList(addresses));
        alr.setConfigurations(new AccessListRequest.Configurations(true));
        this.PATCH(this.getApiDevopsEndpointAccessListsDb(), JsonUtils.marshall(alr));
    }

    public String getApiDevopsEndpointAccessListsDb() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/databases/" + this.db.getId() + "/access-list";
    }
}

