/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;

public class AstraRc {
    public static final String ASTRARC_FILENAME = ".astrarc";
    public static final String ASTRARC_DEFAULT = "default";
    public static final String ENV_USER_HOME = "user.home";
    public static final String ENV_LINE_SEPERATOR = "line.separator";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String ASTRA_DB_APPLICATION_TOKEN = "ASTRA_DB_APPLICATION_TOKEN";
    private final Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();
    private File configFile;

    public AstraRc() {
        this(AstraRc.getDefaultConfigurationFileName());
    }

    public AstraRc(String fileName) {
        this.configFile = new File(fileName);
        if (!this.configFile.exists()) {
            this.createConfigFileIfNotExists();
        }
        this.parseConfigFile();
    }

    public static boolean isDefaultConfigFileExists() {
        return new File(AstraRc.getDefaultConfigurationFileName()).exists();
    }

    public static String getDefaultConfigurationFileName() {
        return System.getProperty(ENV_USER_HOME) + File.separator + ASTRARC_FILENAME;
    }

    public boolean isSectionExists(String sectionName) {
        return sectionName != null && this.sections.containsKey(sectionName);
    }

    public Map<String, Map<String, String>> getSections() {
        return this.sections;
    }

    public Map<String, String> getSection(String sectionName) {
        if (this.isSectionExists(sectionName)) {
            return this.sections.get(sectionName);
        }
        return null;
    }

    public boolean deleteSection(String sectionName) {
        boolean should_delete = this.isSectionExists(sectionName);
        if (should_delete) {
            this.sections.remove(sectionName);
        }
        return should_delete;
    }

    public Optional<String> getSectionKey(String sectionName, String key) {
        Optional<String> result = Optional.empty();
        if (this.isSectionExists(sectionName)) {
            result = Optional.ofNullable(this.sections.get(sectionName).get(key));
        }
        return result;
    }

    public void updateSectionKey(String sectionName, String key, String value) {
        if (!this.isSectionExists(sectionName)) {
            this.sections.put(sectionName, new HashMap());
        }
        this.sections.get(sectionName).put(key, value);
    }

    public void renameSection(String sectionOld, String sectionNew) {
        this.copySection(sectionOld, sectionNew);
        this.sections.remove(sectionOld);
    }

    public void copySection(String sectionOld, String sectionNew) {
        if (this.isSectionExists(sectionOld)) {
            this.sections.remove(sectionNew);
            this.sections.put(sectionNew, new HashMap());
            this.getSection(sectionOld).entrySet().forEach(m -> this.sections.get(sectionNew).put((String)m.getKey(), (String)m.getValue()));
        }
    }

    private boolean createConfigFileIfNotExists() {
        if (!this.configFile.exists()) {
            try {
                return this.configFile.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create configuration file " + this.configFile.getPath());
            }
        }
        return false;
    }

    public void save() {
        FileWriter out = null;
        try {
            out = new FileWriter(this.configFile);
            out.write(this.renderSections());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot save configuration file", e);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseConfigFile() {
        try (Scanner scanner = new Scanner(this.configFile);){
            if (this.configFile.exists()) {
                String sectionName = "";
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("[")) {
                        sectionName = line.replaceAll("\\[", "").replaceAll("\\]", "").trim();
                        this.sections.put(sectionName, new HashMap());
                        continue;
                    }
                    if (line.isEmpty() || line.startsWith("#") || "".equals(line)) continue;
                    int off = line.indexOf("=");
                    if (off < 0) {
                        throw new IllegalArgumentException("Cannot parse file " + this.configFile.getName() + ", line '" + line + "' invalid format expecting key=value");
                    }
                    String key = line.substring(0, off);
                    String val = line.substring(off + 1);
                    this.sections.get(sectionName).put(key, val);
                }
                scanner.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot read configuration file", e);
        }
    }

    public String renderSections() {
        StringBuilder sb = new StringBuilder();
        this.sections.keySet().forEach(s -> sb.append(this.renderSection((String)s)));
        return sb.toString();
    }

    public String renderSection(String sectionName) {
        StringBuilder sb = new StringBuilder();
        if (sectionName != null && this.sections.containsKey(sectionName)) {
            sb.append(LINE_SEPARATOR + "[" + sectionName + "]" + LINE_SEPARATOR);
            this.sections.get(sectionName).entrySet().forEach(line -> sb.append((String)line.getKey() + "=" + (String)line.getValue() + LINE_SEPARATOR));
        }
        return sb.toString();
    }

    public void createSectionWithToken(String sectionName, String token) {
        this.updateSectionKey(sectionName, ASTRA_DB_APPLICATION_TOKEN, token);
        if (!this.isSectionExists(ASTRARC_DEFAULT)) {
            this.copySection(sectionName, ASTRARC_DEFAULT);
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }
}

