/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import com.dtsx.astra.sdk.db.AstraDbClient;
import com.dtsx.astra.sdk.db.DatabaseClient;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationBuilder;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationRequest;
import com.dtsx.astra.sdk.db.domain.DatabaseStatusType;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.AstraRc;
import com.dtsx.astra.sdk.utils.Utils;
import java.io.IOException;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    public static final String TEST_REGION = "us-east1";
    public static final String TEST_TIER = "serverless";
    public static final CloudProviderType TEST_PROVIDER = CloudProviderType.GCP;
    static Logger logger = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static String getAstraToken() {
        String token = null;
        if (AstraRc.isDefaultConfigFileExists()) {
            token = new AstraRc().getSectionKey("default", "ASTRA_DB_APPLICATION_TOKEN").orElse(null);
        }
        return Optional.ofNullable(Utils.readEnvVariable("ASTRA_DB_APPLICATION_TOKEN").orElse(token)).orElseThrow(() -> new IllegalStateException("ASTRA_DB_APPLICATION_TOKEN is not defined as env variable or present in file ~/.astrarc"));
    }

    public static String setupVectorDatabase(String dbName, String keyspace) {
        return TestUtils.setupDatabase(TestUtils.getAstraToken(), AstraEnvironment.PROD, dbName, keyspace, true);
    }

    public static String setupVectorDatabase(AstraEnvironment env, String dbName, String keyspace) {
        return TestUtils.setupDatabase(TestUtils.getAstraToken(), env, dbName, keyspace, true);
    }

    public static String setupDatabase(AstraEnvironment env, String dbName, String keyspace) {
        return TestUtils.setupDatabase(TestUtils.getAstraToken(), env, dbName, keyspace, false);
    }

    public static String setupDatabase(String dbName, String keyspace) {
        return TestUtils.setupDatabase(TestUtils.getAstraToken(), AstraEnvironment.PROD, dbName, keyspace, false);
    }

    public static String setupDatabase(AstraEnvironment env, String dbName, String keyspace, boolean vector) {
        return TestUtils.setupDatabase(TestUtils.getAstraToken(), env, dbName, keyspace, vector);
    }

    public static String setupDatabase(String token, AstraEnvironment env, String dbName, String keyspace, boolean vector) {
        AstraDbClient devopsDbCli = new AstraDbClient(TestUtils.getAstraToken(), env);
        Optional<Database> optDb = devopsDbCli.findByName(dbName).findAny();
        if (optDb.isPresent()) {
            Database db = optDb.get();
            DatabaseClient dbClient = devopsDbCli.database(db.getId());
            if (db.getStatus().equals((Object)DatabaseStatusType.HIBERNATED)) {
                logger.info("Resume DB {} as HIBERNATED ", (Object)dbName);
                TestUtils.resumeDb(optDb.get());
                TestUtils.waitForDbStatus(dbClient, DatabaseStatusType.ACTIVE, 500);
            }
            if (!dbClient.keyspaces().findAll().contains(keyspace)) {
                dbClient.keyspaces().create(keyspace);
                TestUtils.waitForDbStatus(dbClient, DatabaseStatusType.ACTIVE, 100);
            }
            return db.getId();
        }
        DatabaseCreationBuilder builder = DatabaseCreationRequest.builder().name(dbName).tier(TEST_TIER).cloudProvider(TEST_PROVIDER).cloudRegion(TEST_REGION).keyspace(keyspace);
        if (vector) {
            builder = builder.withVector();
        }
        String serverlessDbId = devopsDbCli.create(builder.build());
        DatabaseClient dbc = new DatabaseClient(devopsDbCli.getToken(), serverlessDbId);
        TestUtils.waitForDbStatus(dbc, DatabaseStatusType.ACTIVE, 180);
        return serverlessDbId;
    }

    public static void waitForDbStatus(DatabaseClient dbc, DatabaseStatusType status, int timeoutSeconds) {
        long top = System.currentTimeMillis();
        while (status != dbc.find().get().getStatus() && System.currentTimeMillis() - top < (long)(1000 * timeoutSeconds)) {
            System.out.print("\u25a0");
            TestUtils.waitForSeconds(5);
        }
        System.out.println("\n");
        if (dbc.find().get().getStatus() != status) {
            throw new IllegalStateException("Database is not in expected state after timeouts");
        }
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void terminateDatabaseByName(AstraDbClient devopsDbCli, String dbName) {
        DatabaseClient dbc = new AstraDbClient(devopsDbCli.getToken()).databaseByName(dbName);
        if (dbc.exist()) {
            dbc.delete();
            TestUtils.waitForDbStatus(dbc, DatabaseStatusType.TERMINATED, 60);
        }
    }

    private static void resumeDb(Database db) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet(ApiLocator.getApiRestEndpoint(db.getId(), db.getInfo().getRegion()) + "/v2/schemas/keyspace");
            request.setHeader("Content-Type", (Object)"application/json");
            request.setHeader("X-Cassandra-Token", (Object)TestUtils.getAstraToken());
            request.setHeader("Content-Type", (Object)"application/json");
            httpClient.execute((ClassicHttpRequest)request).close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot resume DB", e);
        }
    }
}

