/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db.domain;

import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationBuilder;

public class DatabaseCreationRequest {
    public static final String DEFAULT_REGION = "us-east1";
    public static final String DEFAULT_TIER = "serverless";
    public static final CloudProviderType DEFAULT_CLOUD = CloudProviderType.GCP;
    private CloudProviderType cloudProvider = DEFAULT_CLOUD;
    private String region = "us-east1";
    private String tier = "serverless";
    private String name;
    private String keyspace;
    private String engineType = null;
    private int capacityUnits = 1;

    public DatabaseCreationRequest() {
    }

    public DatabaseCreationRequest(DatabaseCreationBuilder builder) {
        this.capacityUnits = builder.capacityUnits;
        this.cloudProvider = builder.cloudProvider;
        this.keyspace = builder.keyspace;
        this.name = builder.name;
        this.region = builder.region;
        this.tier = builder.tier;
        if (builder.vector) {
            this.engineType = "cc";
        }
    }

    public static DatabaseCreationBuilder builder() {
        return new DatabaseCreationBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public CloudProviderType getCloudProvider() {
        return this.cloudProvider;
    }

    public String getTier() {
        return this.tier;
    }

    public int getCapacityUnits() {
        return this.capacityUnits;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String toString() {
        return "DatabaseCreationRequest [name=" + this.name + ", keyspace=" + this.keyspace + ", cloudProvider=" + (Object)((Object)this.cloudProvider) + ", tier=" + this.tier + ", capacityUnits=" + this.capacityUnits + ", region=" + this.region + "]";
    }
}

