/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.org;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.AstraDevopsApiClient;
import com.dtsx.astra.sdk.org.RolesClient;
import com.dtsx.astra.sdk.org.domain.InviteUserRequest;
import com.dtsx.astra.sdk.org.domain.ResponseAllUsers;
import com.dtsx.astra.sdk.org.domain.Role;
import com.dtsx.astra.sdk.org.domain.User;
import com.dtsx.astra.sdk.org.exception.UserNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.IdUtils;
import com.dtsx.astra.sdk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class UsersClient
extends AbstractApiClient {
    public UsersClient(String token) {
        this(token, ApiLocator.AstraEnvironment.PROD);
    }

    public UsersClient(String token, ApiLocator.AstraEnvironment env) {
        super(token, env);
    }

    public Stream<User> findAll() {
        ApiResponseHttp res = this.GET(this.getEndpointUsers());
        return JsonUtils.unmarshallBean(res.getBody(), ResponseAllUsers.class).getUsers().stream();
    }

    public Optional<User> find(String userId) {
        ApiResponseHttp res = this.GET(this.getEndpointUser(userId));
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.of(JsonUtils.unmarshallBean(res.getBody(), User.class));
    }

    public Optional<User> findByEmail(String email) {
        Assert.hasLength(email, "User email should not be null nor empty");
        return this.findAll().filter(u -> u.getEmail().equalsIgnoreCase(email)).findFirst();
    }

    public boolean exist(String userId) {
        return this.find(userId).isPresent();
    }

    public boolean existByEmail(String userEmail) {
        return this.findByEmail(userEmail).isPresent();
    }

    public void delete(String userId) {
        if (!this.exist(userId)) {
            throw new UserNotFoundException(userId);
        }
        this.DELETE(this.getEndpointUser(userId));
    }

    public void deleteByEmail(String userEmail) {
        this.delete(this.findByEmail(userEmail).get().getUserId());
    }

    public void invite(String email, String ... roles) {
        Assert.notNull(email, "User email");
        Assert.notNull(roles, "User roles");
        Assert.isTrue(roles.length > 0, "Roles list cannot be empty");
        RolesClient rolesClient = new RolesClient(this.token);
        AstraDevopsApiClient devopsApiClient = new AstraDevopsApiClient(this.token);
        InviteUserRequest inviteRequest = new InviteUserRequest(devopsApiClient.getOrganizationId(), email);
        Arrays.asList(roles).forEach(currentRole -> {
            if (IdUtils.isUUID(currentRole)) {
                inviteRequest.addRoles((String)currentRole);
            } else {
                Optional<Role> opt = rolesClient.findByName((String)currentRole);
                if (opt.isPresent()) {
                    inviteRequest.addRoles(opt.get().getId());
                } else {
                    throw new IllegalArgumentException("Cannot find role with name " + currentRole);
                }
            }
        });
        this.PUT(this.getEndpointUsers(), JsonUtils.marshall(inviteRequest));
    }

    public void updateRoles(String userId, String ... roles) {
        Assert.notNull(roles, "User roles");
        Assert.isTrue(roles.length > 0, "Roles list cannot be empty");
        if (!this.exist(userId)) {
            throw new RuntimeException("User '" + userId + "' has not been found");
        }
        HashMap mapRoles = new HashMap();
        mapRoles.put("roles", new ArrayList());
        RolesClient rolesClient = new RolesClient(this.token);
        Arrays.stream(roles).forEach(currentRole -> {
            if (IdUtils.isUUID(currentRole)) {
                ((List)mapRoles.get("roles")).add(currentRole);
            } else {
                Optional<Role> opt = rolesClient.findByName((String)currentRole);
                if (opt.isPresent()) {
                    ((List)mapRoles.get("roles")).add(opt.get().getId());
                } else {
                    throw new IllegalArgumentException("Cannot find role with id " + currentRole);
                }
            }
        });
        this.PUT(this.getEndpointUser(userId) + "/roles", JsonUtils.marshall(mapRoles));
    }

    public String getEndpointUsers() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/organizations/users";
    }

    private String getEndpointUser(String userId) {
        return this.getEndpointUsers() + "/" + userId;
    }
}

