/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.streaming.TenantCdcClient;
import com.dtsx.astra.sdk.streaming.TenantLimitsClient;
import com.dtsx.astra.sdk.streaming.TenantStatsClient;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantClient
extends AbstractApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantClient.class);
    private final String tenantId;

    public TenantClient(String token, String tenantId) {
        this(token, ApiLocator.AstraEnvironment.PROD, tenantId);
    }

    public TenantClient(String token, ApiLocator.AstraEnvironment env, String tenantId) {
        super(token, env);
        Assert.hasLength(tenantId, "tenantId");
        this.tenantId = tenantId;
    }

    public TenantLimitsClient limits() {
        return new TenantLimitsClient(this.token, this.tenantId);
    }

    public TenantCdcClient cdc() {
        return new TenantCdcClient(this.token, this.tenantId);
    }

    public TenantStatsClient stats() {
        return new TenantStatsClient(this.token, this.tenantId);
    }

    public String getEndpointTenant() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/tenants/" + this.tenantId;
    }
}

