/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.streaming.domain.Tenant;
import com.dtsx.astra.sdk.streaming.domain.TenantLimit;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.stream.Stream;

public class TenantLimitsClient
extends AbstractApiClient {
    private final Tenant tenant;

    public TenantLimitsClient(String token, String tenantId) {
        this(token, ApiLocator.AstraEnvironment.PROD, tenantId);
    }

    public TenantLimitsClient(String token, ApiLocator.AstraEnvironment env, String tenantId) {
        super(token, env);
        Assert.hasLength(tenantId, "tenantId");
        this.tenant = new AstraStreamingClient(token, env).get(tenantId);
    }

    public Stream<TenantLimit> limits() {
        ApiResponseHttp res = this.GET(this.getEndpointTenantLimits());
        return JsonUtils.unmarshallType(res.getBody(), new TypeReference<List<TenantLimit>>(){}).stream();
    }

    public String getEndpointTenantLimits() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/tenants/" + this.tenant.getTenantName() + "/limits";
    }
}

