/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import com.dtsx.astra.sdk.db.AstraDbClient;
import com.dtsx.astra.sdk.db.DatabaseClient;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationRequest;
import com.dtsx.astra.sdk.db.domain.DatabaseStatusType;
import java.util.List;
import java.util.stream.Collectors;

public class TestUtils {
    public static final String TEST_DBNAME = "sdk_tests";
    public static final String TEST_NAMESPACE = "java";
    public static final String TEST_REGION = "us-east1";
    public static final CloudProviderType TEST_PROVIDER = CloudProviderType.GCP;
    public static final String TEST_TIER = "serverless";

    private TestUtils() {
    }

    public static void waitForDbStatus(DatabaseClient dbc, DatabaseStatusType status, int timeoutSeconds) {
        long top = System.currentTimeMillis();
        while (status != dbc.find().get().getStatus() && System.currentTimeMillis() - top < (long)(1000 * timeoutSeconds)) {
            System.out.print("\u25a0");
            TestUtils.waitForSeconds(5);
        }
        System.out.println("\n");
        if (dbc.find().get().getStatus() != status) {
            throw new IllegalStateException("Database is not in expected state after timeouts");
        }
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String createDbAndKeyspaceIfNotExist(AstraDbClient devopsDbCli, String dbName, String keyspace) {
        List dbs = devopsDbCli.findByName(dbName).collect(Collectors.toList());
        if (dbs.size() > 0) {
            Database db = (Database)dbs.get(0);
            DatabaseClient dbc = new DatabaseClient(devopsDbCli.getToken(), db.getId());
            if (!db.getInfo().getKeyspaces().contains(keyspace)) {
                dbc.keyspaces().create(keyspace);
                TestUtils.waitForDbStatus(dbc, DatabaseStatusType.ACTIVE, 60);
            }
            return db.getId();
        }
        String serverlessDbId = devopsDbCli.create(DatabaseCreationRequest.builder().name(dbName).tier(TEST_TIER).cloudProvider(TEST_PROVIDER).cloudRegion(TEST_REGION).keyspace(keyspace).build());
        DatabaseClient dbc = new DatabaseClient(devopsDbCli.getToken(), serverlessDbId);
        TestUtils.waitForDbStatus(dbc, DatabaseStatusType.ACTIVE, 120);
        return serverlessDbId;
    }

    public static void terminateDatabaseByName(AstraDbClient devopsDbCli, String dbName) {
        DatabaseClient dbc = new AstraDbClient(devopsDbCli.getToken()).databaseByName(dbName);
        if (dbc.exist()) {
            dbc.delete();
            TestUtils.waitForDbStatus(dbc, DatabaseStatusType.TERMINATED, 60);
        }
    }
}

