/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.HttpClientWrapper;

public abstract class AbstractApiClient {
    protected final String token;
    protected final ApiLocator.AstraEnvironment environment;

    public AbstractApiClient(String token, ApiLocator.AstraEnvironment env) {
        Assert.hasLength(token, "token");
        this.token = token;
        this.environment = env;
    }

    public String getToken() {
        return this.token;
    }

    public ApiLocator.AstraEnvironment getEnvironment() {
        return this.environment;
    }

    public HttpClientWrapper getHttpClient() {
        return HttpClientWrapper.getInstance();
    }

    public ApiResponseHttp GET(String url) {
        return this.getHttpClient().GET(url, this.getToken());
    }

    public ApiResponseHttp HEAD(String url) {
        System.out.println(url);
        return this.getHttpClient().HEAD(url, this.getToken());
    }

    public ApiResponseHttp POST(String url) {
        return this.getHttpClient().POST(url, this.getToken());
    }

    public ApiResponseHttp POST(String url, String body) {
        return this.getHttpClient().POST(url, this.getToken(), body);
    }

    public void PUT(String url, String body) {
        this.getHttpClient().PUT(url, this.getToken(), body);
    }

    public void PATCH(String url, String body) {
        this.getHttpClient().PATCH(url, this.getToken(), body);
    }

    public void DELETE(String url) {
        this.getHttpClient().DELETE(url, this.getToken());
    }

    public void assertHttpCodeAccepted(ApiResponseHttp res, String action, String entityId) {
        String errorMsg = " Cannot " + action + " id=" + entityId + " code=" + res.getCode() + " msg=" + res.getBody();
        Assert.isTrue(202 == res.getCode(), errorMsg);
    }
}

