/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.AstraDbClient;
import com.dtsx.astra.sdk.org.KeysClient;
import com.dtsx.astra.sdk.org.RolesClient;
import com.dtsx.astra.sdk.org.TokensClient;
import com.dtsx.astra.sdk.org.UsersClient;
import com.dtsx.astra.sdk.org.domain.Organization;
import com.dtsx.astra.sdk.org.domain.ResponseAllUsers;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.JsonUtils;
import java.util.Map;

public class AstraDevopsApiClient
extends AbstractApiClient {
    public AstraDevopsApiClient(String token) {
        this(token, ApiLocator.AstraEnvironment.PROD);
    }

    public AstraDevopsApiClient(String token, ApiLocator.AstraEnvironment env) {
        super(token, env);
    }

    public String getOrganizationId() {
        ApiResponseHttp res = this.getHttpClient().GET(ApiLocator.getApiDevopsEndpoint(this.environment) + "/currentOrg", this.token);
        return (String)JsonUtils.unmarshallBean(res.getBody(), Map.class).get("id");
    }

    public Organization getOrganization() {
        ApiResponseHttp res = this.getHttpClient().GET(this.users().getEndpointUsers(), this.token);
        ResponseAllUsers body = JsonUtils.unmarshallBean(res.getBody(), ResponseAllUsers.class);
        return new Organization(body.getOrgId(), body.getOrgName());
    }

    public AstraDbClient db() {
        return new AstraDbClient(this.token, this.environment);
    }

    public AstraStreamingClient streaming() {
        return new AstraStreamingClient(this.token, this.environment);
    }

    public UsersClient users() {
        return new UsersClient(this.token, this.environment);
    }

    public RolesClient roles() {
        return new RolesClient(this.token, this.environment);
    }

    public KeysClient keys() {
        return new KeysClient(this.token, this.environment);
    }

    public TokensClient tokens() {
        return new TokensClient(this.token, this.environment);
    }
}

