/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DatabaseClient;
import com.dtsx.astra.sdk.db.DbRegionsClient;
import com.dtsx.astra.sdk.db.domain.AccessList;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationRequest;
import com.dtsx.astra.sdk.db.domain.DatabaseFilter;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AstraDbClient
extends AbstractApiClient {
    private static final TypeReference<List<Database>> RESPONSE_DATABASES = new TypeReference<List<Database>>(){};
    private static final TypeReference<List<AccessList>> RESPONSE_ACCESS_LIST = new TypeReference<List<AccessList>>(){};

    public AstraDbClient(String token) {
        this(token, ApiLocator.AstraEnvironment.PROD);
    }

    public AstraDbClient(String token, ApiLocator.AstraEnvironment env) {
        super(token, env);
    }

    public DbRegionsClient regions() {
        return new DbRegionsClient(this.token);
    }

    public Stream<AccessList> findAllAccessLists() {
        return JsonUtils.unmarshallType(this.GET(this.getEndpointAccessLists()).getBody(), RESPONSE_ACCESS_LIST).stream();
    }

    public Stream<Database> findAll() {
        return this.search(DatabaseFilter.builder().include(DatabaseFilter.Include.ALL).provider(CloudProviderType.ALL).limit(1000).build());
    }

    public Stream<Database> findAllNonTerminated() {
        return this.search(DatabaseFilter.builder().build());
    }

    public Stream<Database> findByName(String name) {
        Assert.hasLength(name, "Database name");
        return this.findAllNonTerminated().filter(db -> name.equals(db.getInfo().getName()));
    }

    public Optional<Database> findFirstByName(String name) {
        return this.findByName(name).findFirst();
    }

    public Optional<Database> findById(String id) {
        Assert.hasLength(id, "Database identifier");
        return this.database(id).find();
    }

    public Stream<Database> search(DatabaseFilter filter) {
        Assert.notNull(filter, "filter");
        ApiResponseHttp res = this.GET(this.getEndpointDatabases() + filter.urlParams());
        return JsonUtils.unmarshallType(res.getBody(), RESPONSE_DATABASES).stream();
    }

    public String create(DatabaseCreationRequest dbCreationRequest) {
        Assert.notNull(dbCreationRequest, "Database creation request");
        ApiResponseHttp res = this.POST(this.getEndpointDatabases(), JsonUtils.marshall(dbCreationRequest));
        if (201 != res.getCode()) {
            throw new IllegalStateException("Expected code 201 to create db but got " + res.getCode() + "body=" + res.getBody());
        }
        return res.getHeaders().get("location");
    }

    public DatabaseClient database(String dbId) {
        Assert.hasLength(dbId, "Database Id should not be null nor empty");
        return new DatabaseClient(this.token, this.environment, dbId);
    }

    public DatabaseClient databaseByName(String dbName) {
        Assert.hasLength(dbName, "Database Id should not be null nor empty");
        List dbs = this.findByName(dbName).collect(Collectors.toList());
        if (1 == dbs.size()) {
            return new DatabaseClient(this.token, this.environment, ((Database)dbs.get(0)).getId());
        }
        throw new IllegalArgumentException("Cannot retrieve database from its name (matching count=" + dbs.size() + ")");
    }

    public String getEndpointDatabases() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/databases";
    }

    public String getEndpointAccessLists() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/access-lists";
    }
}

