/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DatabaseClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.exception.KeyspaceAlreadyExistException;
import com.dtsx.astra.sdk.db.exception.KeyspaceNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.Assert;
import java.util.Set;

public class DbKeyspacesClient
extends AbstractApiClient {
    private final Database db;

    public DbKeyspacesClient(String token, String databaseId) {
        this(token, ApiLocator.AstraEnvironment.PROD, databaseId);
    }

    public DbKeyspacesClient(String token, ApiLocator.AstraEnvironment env, String databaseId) {
        super(token, env);
        Assert.hasLength(databaseId, "databaseId");
        this.db = new DatabaseClient(token, env, databaseId).get();
    }

    public Set<String> findAll() {
        return this.db.getInfo().getKeyspaces();
    }

    public boolean exist(String keyspace) {
        return this.findAll().contains(keyspace);
    }

    public void create(String keyspace) {
        Assert.hasLength(keyspace, "keyspace");
        if (this.db.getInfo().getKeyspaces().contains(keyspace)) {
            throw new KeyspaceAlreadyExistException(keyspace, this.db.getInfo().getName());
        }
        this.getHttpClient().POST(this.getEndpointKeyspace(keyspace), this.getToken());
    }

    public void delete(String keyspace) {
        Assert.hasLength(keyspace, "keyspace");
        if (!this.db.getInfo().getKeyspaces().contains(keyspace)) {
            throw new KeyspaceNotFoundException(this.db.getInfo().getName(), keyspace);
        }
        this.getHttpClient().DELETE(this.getEndpointKeyspace(keyspace), this.getToken());
    }

    public String getEndpointKeyspace(String keyspaceName) {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/databases/" + this.db.getId() + "/keyspaces/" + keyspaceName;
    }
}

