/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import com.dtsx.astra.sdk.utils.Assert;

public class ApiLocator {
    public static final String HTTPS = "https://";

    private ApiLocator() {
    }

    public static String getApiDevopsEndpoint(AstraEnvironment env) {
        return env.getEndPoint();
    }

    public static final String getApiRestEndpoint(String dbId, String dbRegion) {
        return ApiLocator.getApiRestEndpoint(AstraEnvironment.PROD, dbId, dbRegion);
    }

    public static final String getApiRestEndpoint(AstraEnvironment env, String dbId, String dbRegion) {
        Assert.hasLength(dbId, "dbId");
        Assert.hasLength(dbRegion, "dbRegion");
        return HTTPS + dbId + "-" + dbRegion + env.getAppsSuffix() + "/api/rest";
    }

    public static final String getApiDocumentEndpoint(String dbId, String dbRegion) {
        return ApiLocator.getApiDocumentEndpoint(AstraEnvironment.PROD, dbId, dbRegion);
    }

    public static final String getApiDocumentEndpoint(AstraEnvironment env, String dbId, String dbRegion) {
        return ApiLocator.getApiRestEndpoint(env, dbId, dbRegion);
    }

    public static final String getEndpointHealthCheck(String dbId, String dbRegion) {
        return ApiLocator.getEndpointHealthCheck(AstraEnvironment.PROD, dbId, dbRegion);
    }

    public static final String getEndpointHealthCheck(AstraEnvironment env, String dbId, String dbRegion) {
        return ApiLocator.getApiRestEndpoint(env, dbId, dbRegion) + "/swagger-ui/";
    }

    public static final String getApiGrpcEndPoint(String dbId, String dbRegion) {
        return ApiLocator.getApiGrpcEndPoint(AstraEnvironment.PROD, dbId, dbRegion);
    }

    public static final String getApiGrpcEndPoint(AstraEnvironment env, String dbId, String dbRegion) {
        Assert.hasLength(dbId, "dbId");
        Assert.hasLength(dbRegion, "dbRegion");
        return dbId + "-" + dbRegion + env.getAppsSuffix();
    }

    public static final String getApiGraphQLEndPoint(String dbId, String dbRegion) {
        return ApiLocator.getApiGraphQLEndPoint(AstraEnvironment.PROD, dbId, dbRegion);
    }

    public static final String getApiGraphQLEndPoint(AstraEnvironment env, String dbId, String dbRegion) {
        Assert.hasLength(dbId, "dbId");
        Assert.hasLength(dbRegion, "dbRegion");
        return HTTPS + dbId + "-" + dbRegion + env.getAppsSuffix() + "/api";
    }

    public static final String getApiGraphQLSchemaEndPoint(String dbId, String dbRegion) {
        return ApiLocator.getApiGraphQLSchemaEndPoint(AstraEnvironment.PROD, dbId, dbRegion);
    }

    public static final String getApiGraphQLSchemaEndPoint(AstraEnvironment env, String dbId, String dbRegion) {
        return ApiLocator.getApiGraphQLEndPoint(env, dbId, dbRegion) + "-schema";
    }

    public static final String getApiGraphQLEndPoint(String dbId, String dbRegion, String keyspace) {
        return ApiLocator.getApiGraphQLEndPoint(AstraEnvironment.PROD, dbId, dbRegion, keyspace);
    }

    public static final String getApiGraphQLEndPoint(AstraEnvironment env, String dbId, String dbRegion, String keyspace) {
        return ApiLocator.getApiGraphQLEndPoint(env, dbId, dbRegion) + "/" + keyspace;
    }

    public static final String getApiStreamingV3Endpoint(AstraEnvironment env, String cluster, String tenant) {
        return HTTPS + cluster + env.getStreamingV3Suffix() + "/admin/v3/astra/tenants/" + tenant;
    }

    public static final String getApiStreamingV2Endpoint(AstraEnvironment env, String cluster) {
        return HTTPS + cluster + env.getStreamingV3Suffix() + "/admin/v2";
    }

    public static enum AstraEnvironment {
        PROD("https://api.astra.datastax.com/v2", ".apps.astra.datastax.com", ".api.streaming.datastax.com"),
        DEV("https://api.dev.cloud.datastax.com/v2", ".apps.astra-dev.datastax.com", ".api.dev.streaming.datastax.com"),
        TEST("https://api.test.cloud.datastax.com/v2", ".apps.astra-test.datastax.com", ".api.staging.streaming.datastax.com");

        private String endpoint;
        private String appsSuffix;
        private String streamingV3Suffix;

        private AstraEnvironment(String endpoint, String appsSuffix, String streaming) {
            this.endpoint = endpoint;
            this.appsSuffix = appsSuffix;
            this.streamingV3Suffix = streaming;
        }

        public String getEndPoint() {
            return this.endpoint;
        }

        public String getAppsSuffix() {
            return this.appsSuffix;
        }

        public String getStreamingV3Suffix() {
            return this.streamingV3Suffix;
        }
    }
}

