/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import com.dtsx.astra.sdk.db.AstraDbClient;
import com.dtsx.astra.sdk.db.DatabaseClient;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.DatabaseCreationRequest;
import com.dtsx.astra.sdk.db.domain.DatabaseStatusType;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.AstraRc;
import com.dtsx.astra.sdk.utils.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    public static final String TEST_DBNAME = "sdk_tests";
    public static final String TEST_NAMESPACE = "java";
    public static final String TEST_REGION = "us-east1";
    public static final CloudProviderType TEST_PROVIDER = CloudProviderType.GCP;
    public static final String TEST_TIER = "serverless";
    static Logger logger = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static void waitForDbStatus(DatabaseClient dbc, DatabaseStatusType status, int timeoutSeconds) {
        long top = System.currentTimeMillis();
        while (status != dbc.find().get().getStatus() && System.currentTimeMillis() - top < (long)(1000 * timeoutSeconds)) {
            System.out.print("\u25a0");
            TestUtils.waitForSeconds(5);
        }
        System.out.println("\n");
        if (dbc.find().get().getStatus() != status) {
            throw new IllegalStateException("Database is not in expected state after timeouts");
        }
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String createDbAndKeyspaceIfNotExist(AstraDbClient devopsDbCli, String dbName, String keyspace) {
        List dbs = devopsDbCli.findByName(dbName).collect(Collectors.toList());
        if (dbs.size() > 0) {
            Database db = (Database)dbs.get(0);
            DatabaseClient dbc = new DatabaseClient(devopsDbCli.getToken(), db.getId());
            if (!db.getInfo().getKeyspaces().contains(keyspace)) {
                dbc.keyspaces().create(keyspace);
                TestUtils.waitForDbStatus(dbc, DatabaseStatusType.ACTIVE, 60);
            }
            return db.getId();
        }
        String serverlessDbId = devopsDbCli.create(DatabaseCreationRequest.builder().name(dbName).tier(TEST_TIER).cloudProvider(TEST_PROVIDER).cloudRegion(TEST_REGION).keyspace(keyspace).build());
        DatabaseClient dbc = new DatabaseClient(devopsDbCli.getToken(), serverlessDbId);
        TestUtils.waitForDbStatus(dbc, DatabaseStatusType.ACTIVE, 120);
        return serverlessDbId;
    }

    public static void terminateDatabaseByName(AstraDbClient devopsDbCli, String dbName) {
        DatabaseClient dbc = new AstraDbClient(devopsDbCli.getToken()).databaseByName(dbName);
        if (dbc.exist()) {
            dbc.delete();
            TestUtils.waitForDbStatus(dbc, DatabaseStatusType.TERMINATED, 60);
        }
    }

    public static String readToken() {
        String token = null;
        if (AstraRc.isDefaultConfigFileExists()) {
            token = new AstraRc().getSectionKey("default", "ASTRA_DB_APPLICATION_TOKEN").orElse(null);
        }
        return Utils.readEnvVariable("ASTRA_DB_APPLICATION_TOKEN").orElse(token);
    }

    private static void resumeDb(Database db) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet(ApiLocator.getApiRestEndpoint(db.getId(), db.getInfo().getRegion()) + "/v2/schemas/keyspace");
            request.setHeader("Content-Type", (Object)"application/json");
            request.setHeader("X-Cassandra-Token", (Object)TestUtils.readToken());
            request.setHeader("Content-Type", (Object)"application/json");
            httpClient.execute((ClassicHttpRequest)request).close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot resume DB", e);
        }
    }

    public static String setupDatabase(String dbName, String keyspace) throws InterruptedException {
        AstraDbClient astraDb = new AstraDbClient(TestUtils.readToken());
        Optional<Database> optDb = astraDb.findByName(dbName).findAny();
        String dbId = null;
        if (!optDb.isPresent()) {
            logger.info("Creating database '{}' as it does not exist, this operation takes about 90s, please wait... ", (Object)dbName);
            dbId = astraDb.create(DatabaseCreationRequest.builder().name(dbName).keyspace(keyspace).cloudRegion(TEST_REGION).withVector().build());
        } else {
            dbId = optDb.get().getId();
            DatabaseClient dbClient = astraDb.database(dbId);
            if (optDb.get().getStatus().equals((Object)DatabaseStatusType.HIBERNATED)) {
                logger.info("Resume DB {} as HIBERNATED ", (Object)dbName);
                TestUtils.resumeDb(optDb.get());
                TestUtils.waitForDbStatus(dbClient, DatabaseStatusType.ACTIVE, 500);
            }
            if (!dbClient.keyspaces().findAll().contains(keyspace)) {
                dbClient.keyspaces().create(keyspace);
            }
        }
        TestUtils.waitForDbStatus(astraDb.database(dbId), DatabaseStatusType.ACTIVE, 500);
        return dbId;
    }
}

