/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.DatabaseRegion;
import com.dtsx.astra.sdk.db.domain.DatabaseRegionServerless;
import com.dtsx.astra.sdk.db.domain.RegionType;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class DbRegionsClient
extends AbstractApiClient {
    public static final String PATH_REGIONS = "/availableRegions";
    public static final String PATH_REGIONS_SERVERLESS = "/regions/serverless";
    public static final TypeReference<List<DatabaseRegion>> TYPE_LIST_REGION = new TypeReference<List<DatabaseRegion>>(){};

    public DbRegionsClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public DbRegionsClient(String token, AstraEnvironment env) {
        super(token, env);
    }

    @Override
    public String getServiceName() {
        return "db.regions";
    }

    public Stream<DatabaseRegion> findAll() {
        ApiResponseHttp res = this.GET(ApiLocator.getApiDevopsEndpoint(this.environment) + PATH_REGIONS, this.getOperationName("find"));
        return JsonUtils.unmarshallType(res.getBody(), TYPE_LIST_REGION).stream();
    }

    public Stream<DatabaseRegionServerless> findAllServerless(RegionType regionType) {
        String url = ApiLocator.getApiDevopsEndpoint(this.environment) + PATH_REGIONS_SERVERLESS;
        switch (regionType) {
            case ALL: {
                url = url + "?region-type=all";
                break;
            }
            case VECTOR: {
                url = url + "?region-type=vector";
                break;
            }
        }
        ApiResponseHttp res = this.GET(url, this.getOperationName("findServerless"));
        return JsonUtils.unmarshallType(res.getBody(), new TypeReference<List<DatabaseRegionServerless>>(){}).stream();
    }

    public Map<String, Map<CloudProviderType, List<DatabaseRegion>>> findAllAsMap() {
        HashMap<String, Map<CloudProviderType, List<DatabaseRegion>>> m = new HashMap<String, Map<CloudProviderType, List<DatabaseRegion>>>();
        this.findAll().forEach(dar -> {
            if (!m.containsKey(dar.getTier())) {
                m.put(dar.getTier(), new HashMap());
            }
            if (!((Map)m.get(dar.getTier())).containsKey((Object)dar.getCloudProvider())) {
                ((Map)m.get(dar.getTier())).put(dar.getCloudProvider(), new ArrayList());
            }
            ((List)((Map)m.get(dar.getTier())).get((Object)dar.getCloudProvider())).add(dar);
        });
        return m;
    }
}

