/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.org;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.org.RolesClient;
import com.dtsx.astra.sdk.org.domain.CreateTokenResponse;
import com.dtsx.astra.sdk.org.domain.DefaultRoles;
import com.dtsx.astra.sdk.org.domain.IamToken;
import com.dtsx.astra.sdk.org.domain.ResponseAllIamTokens;
import com.dtsx.astra.sdk.org.domain.Role;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import java.util.Optional;
import java.util.stream.Stream;

public class TokensClient
extends AbstractApiClient {
    private final RolesClient rolesClient;

    public TokensClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public TokensClient(String token, AstraEnvironment env) {
        super(token, env);
        this.rolesClient = new RolesClient(token, env);
    }

    @Override
    public String getServiceName() {
        return "tokens";
    }

    public Stream<IamToken> findAll() {
        ApiResponseHttp res = this.GET(this.getEndpointTokens(), this.getOperationName("find"));
        return JsonUtils.unmarshallBean(res.getBody(), ResponseAllIamTokens.class).getClients().stream();
    }

    public Optional<IamToken> findById(String tokenId) {
        return this.findAll().filter(t -> t.getClientId().equalsIgnoreCase(tokenId)).findFirst();
    }

    public boolean exist(String tokenId) {
        return this.findById(tokenId).isPresent();
    }

    public void delete(String tokenId) {
        if (!this.exist(tokenId)) {
            throw new RuntimeException("Token '" + tokenId + "' has not been found");
        }
        this.DELETE(this.getEndpointToken(tokenId), this.getOperationName("delete"));
    }

    public CreateTokenResponse create(String role) {
        Assert.hasLength(role, "role");
        Optional<Role> optRole = this.rolesClient.findByName(role);
        String roleId = optRole.isPresent() ? optRole.get().getId() : this.rolesClient.get(role).getId();
        String body = "{ \"roles\": [ \"" + JsonUtils.escapeJson(roleId) + "\"]}";
        ApiResponseHttp res = this.POST(this.getEndpointTokens(), body, this.getOperationName("create"));
        return JsonUtils.unmarshallBean(res.getBody(), CreateTokenResponse.class);
    }

    public CreateTokenResponse create(DefaultRoles role) {
        return this.create(role.getName());
    }

    public String getEndpointTokens() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/clientIdSecrets";
    }

    public String getEndpointToken(String tokenId) {
        return this.getEndpointTokens() + "/" + tokenId;
    }
}

