/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.AstraOpsClient;
import com.dtsx.astra.sdk.streaming.TenantCdcClient;
import com.dtsx.astra.sdk.streaming.TenantLimitsClient;
import com.dtsx.astra.sdk.streaming.TenantStatsClient;
import com.dtsx.astra.sdk.streaming.domain.Tenant;
import com.dtsx.astra.sdk.streaming.exception.TenantNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import java.util.Optional;

public class TenantClient
extends AbstractApiClient {
    private final String tenantId;
    private final String organizationId;

    public TenantClient(String token, String tenantId) {
        this(token, AstraEnvironment.PROD, tenantId);
    }

    public TenantClient(String token, AstraEnvironment env, String tenantId) {
        super(token, env);
        Assert.hasLength(tenantId, "tenantId");
        this.tenantId = tenantId;
        this.organizationId = new AstraOpsClient(token, env).getOrganizationId();
    }

    @Override
    public String getServiceName() {
        return "streaming.tenants";
    }

    public Optional<Tenant> find() {
        System.out.println("getEndpointTenant() = " + this.getEndpointTenant());
        ApiResponseHttp res = this.GET(this.getEndpointTenantWithOrganizationId(), this.getOperationName("find"));
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.of(JsonUtils.unmarshallBean(res.getBody(), Tenant.class));
    }

    public Tenant get() {
        return this.find().orElseThrow(() -> new TenantNotFoundException(this.tenantId));
    }

    public boolean exist() {
        return this.find().isPresent();
    }

    public TenantLimitsClient limits() {
        return new TenantLimitsClient(this.token, this.tenantId);
    }

    public TenantCdcClient cdc() {
        return new TenantCdcClient(this.token, this.tenantId);
    }

    public TenantStatsClient stats() {
        return new TenantStatsClient(this.token, this.tenantId);
    }

    public String getEndpointTenant() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/tenants/" + this.tenantId;
    }

    public String getEndpointTenantWithOrganizationId() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/orgs/" + this.organizationId + "/tenants/" + this.tenantId;
    }
}

