/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractCassandraTable<RECORD> {
    public static final String SAI_INDEX_CLASSNAME = "org.apache.cassandra.index.sai.StorageAttachedIndex";
    public static final String PARTITION_ID = "partition_id";
    public static final String ROW_ID = "row_id";
    public static final String ATTRIBUTES_BLOB = "attributes_blob";
    public static final String BODY_BLOB = "body_blob";
    public static final String METADATA_S = "metadata_s";
    public static final String VECTOR = "vector";
    public static final String COLUMN_SIMILARITY = "similarity";
    public static final int DEFAULT_RECORD_COUNT = 4;
    protected final CqlSession cqlSession;
    protected final String keyspaceName;
    protected final String tableName;

    public AbstractCassandraTable(CqlSession session, String keyspaceName, String tableName) {
        this.cqlSession = session;
        this.keyspaceName = keyspaceName;
        this.tableName = tableName;
    }

    public abstract void createSchema();

    public abstract void put(RECORD var1);

    public abstract RECORD mapRow(Row var1);

    public CompletableFuture<Void> putAsync(RECORD inputRow) {
        return CompletableFuture.runAsync(() -> this.put(inputRow));
    }

    public void delete() {
        this.cqlSession.execute((Statement)SchemaBuilder.dropTable((String)this.keyspaceName, (String)this.tableName).ifExists().build());
    }

    public void clear() {
        this.cqlSession.execute((Statement)QueryBuilder.truncate((String)this.keyspaceName, (String)this.tableName).build());
    }
}

