/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.dtsx.astra.sdk.cassio.AbstractCassandraTable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredCassandraTable
extends AbstractCassandraTable<Record> {
    private static final Logger log = LoggerFactory.getLogger(ClusteredCassandraTable.class);
    private final PreparedStatement findPartitionStatement;
    private final PreparedStatement deletePartitionStatement;
    private final PreparedStatement deleteRowStatement;
    private final PreparedStatement insertRowStatement;
    private final PreparedStatement findRowStatement;

    public ClusteredCassandraTable(@NonNull CqlSession session, @NonNull String keyspaceName, @NonNull String tableName) {
        super(session, keyspaceName, tableName);
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keyspaceName == null) {
            throw new NullPointerException("keyspaceName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.createSchema();
        this.findPartitionStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)tableName).all().whereColumn("partition_id").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        this.deletePartitionStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)tableName).whereColumn("partition_id").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        this.findRowStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)tableName).all().whereColumn("partition_id").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("row_id").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        this.deleteRowStatement = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)tableName).whereColumn("partition_id").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("row_id").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        this.insertRowStatement = session.prepare(QueryBuilder.insertInto((String)tableName).value("partition_id", (Term)QueryBuilder.bindMarker()).value("row_id", (Term)QueryBuilder.bindMarker()).value("body_blob", (Term)QueryBuilder.bindMarker()).build());
    }

    @Override
    public void createSchema() {
        this.cqlSession.execute((Statement)((CreateTableWithOptions)SchemaBuilder.createTable((String)this.tableName).ifNotExists().withPartitionKey("partition_id", DataTypes.TEXT).withClusteringColumn("row_id", DataTypes.TIMEUUID).withColumn("body_blob", DataTypes.TEXT).withClusteringOrder("row_id", ClusteringOrder.DESC)).build());
        log.info("+ Table '{}' has been created (if needed).", (Object)this.tableName);
    }

    @Override
    public void put(@NonNull Record row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        this.cqlSession.execute((Statement)this.insertRowStatement.bind(new Object[]{row.getPartitionId(), row.getRowId(), row.getBody()}));
    }

    @Override
    public Record mapRow(@NonNull Row row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        return new Record(row.getString("partition_id"), row.getUuid("row_id"), row.getString("body_blob"));
    }

    public List<Record> findPartition(@NonNull String partitionDd) {
        if (partitionDd == null) {
            throw new NullPointerException("partitionDd is marked non-null but is null");
        }
        return this.cqlSession.execute((Statement)this.findPartitionStatement.bind(new Object[]{partitionDd})).all().stream().map(this::mapRow).collect(Collectors.toList());
    }

    public void upsertPartition(List<Record> rows) {
        if (rows != null && !rows.isEmpty()) {
            BatchStatementBuilder batch = BatchStatement.builder((BatchType)BatchType.LOGGED);
            String currentPartitionId = null;
            for (Record row : rows) {
                if (currentPartitionId != null && !currentPartitionId.equals(row.getPartitionId())) {
                    log.warn("Not all rows are part of the same partition");
                }
                currentPartitionId = row.getPartitionId();
                batch.addStatement((BatchableStatement)this.insertRowStatement.bind(new Object[]{row.getPartitionId(), row.getRowId(), row.getBody()}));
            }
            this.cqlSession.execute((Statement)batch.build());
        }
    }

    public Optional<Record> findById(String partition, UUID rowId) {
        return Optional.ofNullable((Row)this.cqlSession.execute((Statement)this.findRowStatement.bind(new Object[]{partition, rowId})).one()).map(this::mapRow);
    }

    public void deletePartition(@NonNull String partitionId) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        this.cqlSession.execute((Statement)this.deletePartitionStatement.bind(new Object[]{partitionId}));
    }

    public void delete(@NonNull String partitionId, @NonNull UUID rowId) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        this.cqlSession.execute((Statement)this.deleteRowStatement.bind(new Object[]{partitionId, rowId}));
    }

    public void insert(@NonNull String partitionId, @NonNull UUID rowId, @NonNull String bodyBlob) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        if (bodyBlob == null) {
            throw new NullPointerException("bodyBlob is marked non-null but is null");
        }
        this.cqlSession.execute((Statement)QueryBuilder.insertInto((String)this.keyspaceName, (String)this.tableName).value("partition_id", (Term)QueryBuilder.literal((Object)partitionId)).value("row_id", (Term)QueryBuilder.literal((Object)rowId)).value("body_blob", (Term)QueryBuilder.literal((Object)bodyBlob)).build());
    }

    public static class Record {
        private String partitionId;
        private UUID rowId;
        private String body;

        public String getPartitionId() {
            return this.partitionId;
        }

        public UUID getRowId() {
            return this.rowId;
        }

        public String getBody() {
            return this.body;
        }

        public void setPartitionId(String partitionId) {
            this.partitionId = partitionId;
        }

        public void setRowId(UUID rowId) {
            this.rowId = rowId;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record other = (Record)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$partitionId = this.getPartitionId();
            String other$partitionId = other.getPartitionId();
            if (this$partitionId == null ? other$partitionId != null : !this$partitionId.equals(other$partitionId)) {
                return false;
            }
            UUID this$rowId = this.getRowId();
            UUID other$rowId = other.getRowId();
            if (this$rowId == null ? other$rowId != null : !((Object)this$rowId).equals(other$rowId)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Record;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $partitionId = this.getPartitionId();
            result = result * 59 + ($partitionId == null ? 43 : $partitionId.hashCode());
            UUID $rowId = this.getRowId();
            result = result * 59 + ($rowId == null ? 43 : ((Object)$rowId).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "ClusteredCassandraTable.Record(partitionId=" + this.getPartitionId() + ", rowId=" + this.getRowId() + ", body=" + this.getBody() + ")";
        }

        public Record(String partitionId, UUID rowId, String body) {
            this.partitionId = partitionId;
            this.rowId = rowId;
            this.body = body;
        }

        public Record() {
        }
    }
}

