/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.dtsx.astra.sdk.cassio.SimilarityMetric;
import java.util.List;
import java.util.Map;

public class SimilaritySearchQuery {
    private int recordCount;
    private double threshold = 0.0;
    private List<Float> embeddings;
    private SimilarityMetric distance = SimilarityMetric.DOT_PRODUCT;
    private Map<String, String> metaData;

    SimilaritySearchQuery(int recordCount, double threshold, List<Float> embeddings, SimilarityMetric distance, Map<String, String> metaData) {
        this.recordCount = recordCount;
        this.threshold = threshold;
        this.embeddings = embeddings;
        this.distance = distance;
        this.metaData = metaData;
    }

    public static SimilaritySearchQueryBuilder builder() {
        return new SimilaritySearchQueryBuilder();
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public List<Float> getEmbeddings() {
        return this.embeddings;
    }

    public SimilarityMetric getDistance() {
        return this.distance;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setEmbeddings(List<Float> embeddings) {
        this.embeddings = embeddings;
    }

    public void setDistance(SimilarityMetric distance) {
        this.distance = distance;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimilaritySearchQuery)) {
            return false;
        }
        SimilaritySearchQuery other = (SimilaritySearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRecordCount() != other.getRecordCount()) {
            return false;
        }
        if (Double.compare(this.getThreshold(), other.getThreshold()) != 0) {
            return false;
        }
        List<Float> this$embeddings = this.getEmbeddings();
        List<Float> other$embeddings = other.getEmbeddings();
        if (this$embeddings == null ? other$embeddings != null : !((Object)this$embeddings).equals(other$embeddings)) {
            return false;
        }
        SimilarityMetric this$distance = this.getDistance();
        SimilarityMetric other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)((Object)this$distance)).equals((Object)other$distance)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimilaritySearchQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRecordCount();
        long $threshold = Double.doubleToLongBits(this.getThreshold());
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        List<Float> $embeddings = this.getEmbeddings();
        result = result * 59 + ($embeddings == null ? 43 : ((Object)$embeddings).hashCode());
        SimilarityMetric $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)((Object)$distance)).hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    public String toString() {
        return "SimilaritySearchQuery(recordCount=" + this.getRecordCount() + ", threshold=" + this.getThreshold() + ", embeddings=" + this.getEmbeddings() + ", distance=" + (Object)((Object)this.getDistance()) + ", metaData=" + this.getMetaData() + ")";
    }

    public static class SimilaritySearchQueryBuilder {
        private int recordCount;
        private double threshold;
        private List<Float> embeddings;
        private SimilarityMetric distance;
        private Map<String, String> metaData;

        SimilaritySearchQueryBuilder() {
        }

        public SimilaritySearchQueryBuilder recordCount(int recordCount) {
            this.recordCount = recordCount;
            return this;
        }

        public SimilaritySearchQueryBuilder threshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public SimilaritySearchQueryBuilder embeddings(List<Float> embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        public SimilaritySearchQueryBuilder distance(SimilarityMetric distance) {
            this.distance = distance;
            return this;
        }

        public SimilaritySearchQueryBuilder metaData(Map<String, String> metaData) {
            this.metaData = metaData;
            return this;
        }

        public SimilaritySearchQuery build() {
            return new SimilaritySearchQuery(this.recordCount, this.threshold, this.embeddings, this.distance, this.metaData);
        }

        public String toString() {
            return "SimilaritySearchQuery.SimilaritySearchQueryBuilder(recordCount=" + this.recordCount + ", threshold=" + this.threshold + ", embeddings=" + this.embeddings + ", distance=" + (Object)((Object)this.distance) + ", metaData=" + this.metaData + ")";
        }
    }
}

