/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.sdk;

import com.datastax.astra.sdk.config.AstraClientConfig;
import com.datastax.oss.driver.api.core.CqlSession;
import com.dtsx.astra.sdk.AstraDevopsApiClient;
import com.dtsx.astra.sdk.db.AstraDbClient;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.streaming.AstraStreamingClient;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import io.stargate.sdk.StargateClient;
import io.stargate.sdk.api.SimpleTokenProvider;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.doc.StargateDocumentApiClient;
import io.stargate.sdk.gql.StargateGraphQLApiClient;
import io.stargate.sdk.grpc.ServiceGrpc;
import io.stargate.sdk.grpc.StargateGrpcApiClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.rest.StargateRestApiClient;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstraClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AstraClient.class);
    public static final String SECURE_CONNECT = "scb_";
    private AstraDevopsApiClient apiDevops;
    private AstraDbClient apiDevopsDatabases;
    private AstraStreamingClient apiDevopsStreaming;
    protected StargateClient stargateClient;
    protected AstraClientConfig astraClientConfig;
    protected String currentDatabaseRegion;

    public AstraClient(String token) {
        this(AstraClient.builder().withToken(token));
    }

    public AstraClient(String dbId, String dbRegion, String token) {
        this(AstraClient.builder().withToken(token).withDatabaseId(dbId).withDatabaseRegion(dbRegion));
    }

    public AstraClient(AstraClientConfig config) {
        this.astraClientConfig = config;
        if (Utils.hasLength((String)config.getToken())) {
            this.apiDevops = new AstraDevopsApiClient(config.getToken(), config.getEnvironmnt());
            this.apiDevopsDatabases = this.apiDevops.db();
            this.apiDevopsStreaming = this.apiDevops.streaming();
            LOGGER.info("+ API(s) Devops     [" + AnsiUtils.green((String)"ENABLED") + "] on [" + config.getEnvironmnt() + "]");
        } else {
            LOGGER.info("+ API(s) Devops     [" + AnsiUtils.red((String)"DISABLED") + "]");
        }
        if (Utils.hasAllLength((String[])new String[]{config.getDatabaseId(), config.getDatabaseRegion()})) {
            LOGGER.info("+ Db: id [" + AnsiUtils.cyan((String)"{}") + "] and region [" + AnsiUtils.cyan((String)"{}") + "]", (Object)config.getDatabaseId(), (Object)config.getDatabaseRegion());
            this.currentDatabaseRegion = config.getDatabaseRegion();
            config.getStargateConfig().setLocalDatacenter(config.getDatabaseRegion());
            if (config.getStargateConfig().isEnabledCql()) {
                if (config.isEnabledDownloadSecureConnectBundle()) {
                    this.downloadAndSetupSecureConnectBundle(config);
                }
                if (Utils.hasAllLength((String[])new String[]{config.getClientId(), config.getClientSecret()})) {
                    config.getStargateConfig().withAuthCredentials(config.getClientId(), config.getClientSecret());
                } else {
                    config.getStargateConfig().withAuthCredentials("token", config.getToken());
                }
            }
            if (config.isEnabledCrossRegionFailOver()) {
                Database db = this.apiDevopsDatabases.database(config.getDatabaseId()).get();
                db.getInfo().getDatacenters().forEach(dc -> {
                    config.getStargateConfig().addServiceRest(dc.getRegion(), new ServiceHttp(dc.getRegion() + "-rest", ApiLocator.getApiRestEndpoint((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion()), ApiLocator.getEndpointHealthCheck((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion())));
                    config.getStargateConfig().addDocumentService(dc.getRegion(), new ServiceHttp(dc.getRegion() + "-doc", ApiLocator.getApiDocumentEndpoint((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion()), ApiLocator.getEndpointHealthCheck((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion())));
                    config.getStargateConfig().addGraphQLService(dc.getRegion(), new ServiceHttp(dc.getRegion() + "-gql", ApiLocator.getApiGraphQLEndPoint((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion()), ApiLocator.getEndpointHealthCheck((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion())));
                    if (config.getStargateConfig().isEnabledGrpc()) {
                        config.getStargateConfig().addGrpcService(dc.getRegion(), new ServiceGrpc(dc.getRegion() + "-grpc", ApiLocator.getApiGrpcEndPoint((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion()) + ":" + 443, ApiLocator.getEndpointHealthCheck((AstraEnvironment)config.getEnvironmnt(), (String)config.getDatabaseId(), (String)dc.getRegion()), true));
                    }
                    if (config.getStargateConfig().isEnabledCql()) {
                        config.getStargateConfig().withCqlCloudSecureConnectBundleDC(dc.getRegion(), config.getSecureConnectBundleFolder() + File.separator + AstraClientConfig.buildScbFileName(config.getDatabaseId(), dc.getRegion()));
                    }
                    config.getStargateConfig().withApiTokenProviderDC(dc.getRegion(), (TokenProvider)new SimpleTokenProvider(config.getToken()));
                });
            } else {
                LOGGER.info("+ Cross-region fallback is disabled.");
                config.getStargateConfig().withApiTokenProviderDC(this.currentDatabaseRegion, (TokenProvider)new SimpleTokenProvider(config.getToken()));
                config.getStargateConfig().addServiceRest(this.currentDatabaseRegion, new ServiceHttp(this.currentDatabaseRegion + "-rest", ApiLocator.getApiRestEndpoint((String)config.getDatabaseId(), (String)this.currentDatabaseRegion), ApiLocator.getEndpointHealthCheck((String)config.getDatabaseId(), (String)this.currentDatabaseRegion)));
                config.getStargateConfig().addDocumentService(this.currentDatabaseRegion, new ServiceHttp(this.currentDatabaseRegion + "-doc", ApiLocator.getApiDocumentEndpoint((String)config.getDatabaseId(), (String)this.currentDatabaseRegion), ApiLocator.getEndpointHealthCheck((String)config.getDatabaseId(), (String)this.currentDatabaseRegion)));
                config.getStargateConfig().addGraphQLService(this.currentDatabaseRegion, new ServiceHttp(this.currentDatabaseRegion + "-gql", ApiLocator.getApiGraphQLEndPoint((String)config.getDatabaseId(), (String)this.currentDatabaseRegion), ApiLocator.getEndpointHealthCheck((String)config.getDatabaseId(), (String)this.currentDatabaseRegion)));
                if (config.getStargateConfig().isEnabledGrpc()) {
                    config.getStargateConfig().addGrpcService(this.currentDatabaseRegion, new ServiceGrpc(this.currentDatabaseRegion + "-grpc", ApiLocator.getApiGrpcEndPoint((String)config.getDatabaseId(), (String)this.currentDatabaseRegion) + ":" + 443, ApiLocator.getEndpointHealthCheck((String)config.getDatabaseId(), (String)this.currentDatabaseRegion), true));
                }
                if (config.getStargateConfig().isEnabledCql()) {
                    config.getStargateConfig().withCqlCloudSecureConnectBundleDC(this.currentDatabaseRegion, config.getSecureConnectBundleFolder() + File.separator + AstraClientConfig.buildScbFileName(config.getDatabaseId(), this.currentDatabaseRegion));
                }
            }
            this.stargateClient = config.getStargateConfig().build();
        } else {
            LOGGER.info("+ API(s) CqlSession [" + AnsiUtils.red((String)"DISABLED") + "]");
            LOGGER.info("+ API(s) Document   [" + AnsiUtils.red((String)"DISABLED") + "]");
            LOGGER.info("+ API(s) Rest       [" + AnsiUtils.red((String)"DISABLED") + "]");
            LOGGER.info("+ API(s) gRPC       [" + AnsiUtils.red((String)"DISABLED") + "]");
        }
        LOGGER.info("[" + AnsiUtils.yellow((String)"AstraClient") + "] has been initialized.");
    }

    private void downloadAndSetupSecureConnectBundle(AstraClientConfig config) {
        if (!new File(config.getSecureConnectBundleFolder()).exists() && new File(config.getSecureConnectBundleFolder()).mkdirs()) {
            LOGGER.info("+ Folder Created to hold SCB");
        }
        LOGGER.info("+ Downloading bundles in: [" + AnsiUtils.cyan((String)"{}") + "]", (Object)config.getSecureConnectBundleFolder());
        this.apiDevopsDatabases.database(config.getDatabaseId()).downloadAllSecureConnectBundles(config.getSecureConnectBundleFolder());
        String scbFile = config.getSecureConnectBundleFolder() + File.separator + AstraClientConfig.buildScbFileName(config.getDatabaseId(), config.getDatabaseRegion());
        config.getStargateConfig().withCqlCloudSecureConnectBundle(scbFile);
    }

    public StargateDocumentApiClient apiStargateDocument() {
        if (this.stargateClient == null) {
            throw new IllegalStateException("Api Document is not available you need to provide dbId/dbRegion/username/password at initialization.");
        }
        return this.stargateClient.apiDocument();
    }

    public StargateRestApiClient apiStargateData() {
        if (this.stargateClient == null) {
            throw new IllegalStateException("Api Rest is not available you need to provide dbId/dbRegion/username/password at initialization.");
        }
        return this.stargateClient.apiRest();
    }

    public StargateGraphQLApiClient apiStargateGraphQL() {
        if (this.stargateClient == null) {
            throw new IllegalStateException("GraphQL Api is not available you need to provide dbId/dbRegion/token at initialization.");
        }
        return this.stargateClient.apiGraphQL();
    }

    public StargateGrpcApiClient apiStargateGrpc() {
        if (this.stargateClient == null) {
            throw new IllegalStateException("GRPC Api is not available you need to provide dbId/dbRegion/token at initialization.");
        }
        return this.stargateClient.apiGrpc();
    }

    public AstraDevopsApiClient apiDevops() {
        if (this.apiDevops == null) {
            throw new IllegalStateException("Api Devops is not available you need to provide a astra Token (AstraCS:...) at initialization.");
        }
        return this.apiDevops;
    }

    public AstraDbClient apiDevopsDatabases() {
        if (this.apiDevopsDatabases == null) {
            throw new IllegalStateException("Api Devops is not available you need to provide clientId/clientName/clientSecret at initialization.");
        }
        return this.apiDevopsDatabases;
    }

    public AstraStreamingClient apiDevopsStreaming() {
        if (this.apiDevopsStreaming == null) {
            throw new IllegalStateException("Api Devops is not available you need to provide clientId/clientName/clientSecret at initialization.");
        }
        return this.apiDevopsStreaming;
    }

    public CqlSession cqlSession() {
        if (this.stargateClient == null || !this.stargateClient.cqlSession().isPresent()) {
            throw new IllegalStateException("CQL Session is not available. Make sure you enabled it with .enableCql() and provide all expected parameters: keyspace, contact points or SCB, user+password ");
        }
        return (CqlSession)this.stargateClient.cqlSession().get();
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.astraClientConfig.getToken());
    }

    public AstraClientConfig getConfig() {
        return this.astraClientConfig;
    }

    public void useRegion(String region) {
        LOGGER.info("Switch to region : {}", (Object)region);
        this.currentDatabaseRegion = region;
        this.stargateClient.setCurrentDatacenter(region);
        this.stargateClient.initCqlSession();
    }

    public static AstraClientConfig builder() {
        return new AstraClientConfig();
    }

    @Override
    public void close() {
        if (null != this.stargateClient) {
            this.stargateClient.close();
        }
    }

    public StargateClient getStargateClient() {
        return this.stargateClient;
    }
}

