/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.sdk.config;

import com.datastax.astra.sdk.AstraClient;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.AstraRc;
import com.evanlennick.retry4j.config.RetryConfig;
import io.stargate.sdk.StargateClientBuilder;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.Utils;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstraClientConfig
implements Serializable {
    private static final long serialVersionUID = 6950028057943051050L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AstraClientConfig.class);
    public static final String ENV_USER_HOME = "user.home";
    public static final String DEFAULT_SCB_FOLDER = System.getProperty("user.home") + File.separator + ".astra" + File.separator + "scb";
    public static final String ASTRA_DB_ID = "ASTRA_DB_ID";
    public static final String ASTRA_DB_REGION = "ASTRA_DB_REGION";
    public static final String ASTRA_DB_CLIENT_ID = "ASTRA_DB_CLIENT_ID";
    public static final String ASTRA_DB_CLIENT_SECRET = "ASTRA_DB_CLIENT_SECRET";
    public static final String ASTRA_DB_KEYSPACE = "ASTRA_DB_KEYSPACE";
    public static final String ASTRA_DB_SCB_FOLDER = "ASTRA_DB_SCB_FOLDER";
    public static final int GRPC_PORT = 443;
    private String token;
    private String clientId;
    private String clientSecret;
    private AstraEnvironment env = AstraEnvironment.PROD;
    private String databaseId;
    private String databaseRegion;
    private final StargateClientBuilder stargateConfig;
    private boolean downloadSecureConnectBundle = true;
    private boolean crossRegionFailOver = true;
    private String secureConnectBundleFolder = DEFAULT_SCB_FOLDER;

    public AstraClientConfig withToken(String applicationToken) {
        Assert.hasLength((String)applicationToken, (String)"applicationToken");
        this.token = applicationToken;
        this.stargateConfig.withApiToken(this.token);
        return this;
    }

    public AstraClientConfig withClientId(String clientId) {
        Assert.hasLength((String)clientId, (String)"clientId");
        this.clientId = clientId;
        return this;
    }

    public AstraClientConfig withClientSecret(String clientSecret) {
        Assert.hasLength((String)clientSecret, (String)"clientSecret");
        this.clientSecret = clientSecret;
        return this;
    }

    public AstraClientConfig env(AstraEnvironment env) {
        this.env = env;
        return this;
    }

    public AstraEnvironment getEnvironmnt() {
        return this.env;
    }

    public String getToken() {
        return this.token;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public AstraClientConfig withDatabaseId(String databaseId) {
        Assert.hasLength((String)databaseId, (String)"databaseId");
        this.databaseId = databaseId;
        return this;
    }

    public AstraClientConfig withDatabaseRegion(String databaseRegion) {
        Assert.hasLength((String)databaseRegion, (String)"databaseRegion");
        this.databaseRegion = databaseRegion;
        return this;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDatabaseRegion() {
        return this.databaseRegion;
    }

    public StargateClientBuilder getStargateConfig() {
        return this.stargateConfig;
    }

    public AstraClientConfig withHttpRequestConfig(RequestConfig reqConfig) {
        this.stargateConfig.withHttpRequestConfig(reqConfig);
        return this;
    }

    public AstraClientConfig withHttpRetryConfig(RetryConfig retryConfig) {
        this.stargateConfig.withHttpRetryConfig(retryConfig);
        return this;
    }

    public AstraClientConfig addHttpObserver(String name, ServiceCallObserver observer) {
        this.stargateConfig.addHttpObserver(name, observer);
        return this;
    }

    public AstraClientConfig withHttpObservers(Map<String, ServiceCallObserver> observers) {
        this.stargateConfig.withHttpObservers(observers);
        return this;
    }

    public AstraClientConfig enableGrpc() {
        this.stargateConfig.enableGrpc();
        return this;
    }

    public String getSecureConnectBundleFolder() {
        return this.secureConnectBundleFolder;
    }

    public AstraClientConfig secureConnectBundleFolder(String path) {
        this.secureConnectBundleFolder = path;
        return this;
    }

    public boolean isEnabledDownloadSecureConnectBundle() {
        return this.downloadSecureConnectBundle;
    }

    public boolean isEnabledCrossRegionFailOver() {
        return this.crossRegionFailOver;
    }

    public AstraClientConfig enableDownloadSecureConnectBundle() {
        this.downloadSecureConnectBundle = true;
        return this;
    }

    public AstraClientConfig enableCrossRegionFailOver() {
        this.crossRegionFailOver = true;
        return this;
    }

    public AstraClientConfig disableDownloadSecureConnectBundle() {
        this.downloadSecureConnectBundle = false;
        return this;
    }

    public AstraClientConfig disableCrossRegionFailOver() {
        this.crossRegionFailOver = false;
        return this;
    }

    public AstraClientConfig withCqlCloudSecureConnectBundle(String scbFile) {
        this.stargateConfig.withCqlCloudSecureConnectBundle(scbFile);
        return this;
    }

    public AstraClientConfig enableCql() {
        this.stargateConfig.enableCql();
        return this;
    }

    public AstraClientConfig withCqlDriverConfig(ProgrammaticDriverConfigLoaderBuilder conf) {
        this.stargateConfig.withCqlDriverConfigLoaderBuilder(conf);
        return this;
    }

    public AstraClientConfig withCqlConsistencyLevel(ConsistencyLevel cl) {
        this.stargateConfig.withCqlConsistencyLevel(cl);
        return this;
    }

    public AstraClientConfig withCqlDriverConfigurationFile(File configFile) {
        this.stargateConfig.withCqlDriverConfigurationFile(configFile);
        return this;
    }

    public AstraClientConfig withCqlKeyspace(String keyspace) {
        this.stargateConfig.withCqlKeyspace(keyspace);
        return this;
    }

    public AstraClientConfig withCqlOptionBoolean(TypedDriverOption<Boolean> option, Boolean du) {
        this.stargateConfig.withCqlOptionBoolean(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionBooleanDC(String dc, TypedDriverOption<Boolean> option, Boolean du) {
        this.stargateConfig.withCqlOptionBooleanDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionBooleanList(TypedDriverOption<List<Boolean>> option, List<Boolean> du) {
        this.stargateConfig.withCqlOptionBooleanList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionBooleanListDC(String dc, TypedDriverOption<List<Boolean>> option, List<Boolean> du) {
        this.stargateConfig.withCqlOptionBooleanListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionClass(TypedDriverOption<Class<?>> option, Class<?> du) {
        this.stargateConfig.withCqlOptionClass(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionClassDC(String dc, TypedDriverOption<Class<?>> option, Class<?> du) {
        this.stargateConfig.withCqlOptionClassDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionClassList(TypedDriverOption<List<Class<?>>> option, List<Class<?>> du) {
        this.stargateConfig.withCqlOptionClassList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionClassListDC(String dc, TypedDriverOption<List<Class<?>>> option, List<Class<?>> du) {
        this.stargateConfig.withCqlOptionClassListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDouble(TypedDriverOption<Double> option, Double du) {
        this.stargateConfig.withCqlOptionDouble(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDoubleDC(String dc, TypedDriverOption<Double> option, Double du) {
        this.stargateConfig.withCqlOptionDoubleDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDoubleList(TypedDriverOption<List<Double>> option, List<Double> du) {
        this.stargateConfig.withCqlOptionDoubleList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDoubleListDC(String dc, TypedDriverOption<List<Double>> option, List<Double> du) {
        this.stargateConfig.withCqlOptionDoubleListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDuration(TypedDriverOption<Duration> option, Duration du) {
        this.stargateConfig.withCqlOptionDuration(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDurationDC(String dc, TypedDriverOption<Duration> option, Duration du) {
        this.stargateConfig.withCqlOptionDurationDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDurationList(TypedDriverOption<List<Duration>> option, List<Duration> du) {
        this.stargateConfig.withCqlOptionDurationList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionDurationListDC(String dc, TypedDriverOption<List<Duration>> option, List<Duration> du) {
        this.stargateConfig.withCqlOptionDurationListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionInteger(TypedDriverOption<Integer> option, Integer du) {
        this.stargateConfig.withCqlOptionInteger(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionIntegerDC(String dc, TypedDriverOption<Integer> option, Integer du) {
        this.stargateConfig.withCqlOptionIntegerDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionIntegerList(TypedDriverOption<List<Integer>> option, List<Integer> du) {
        this.stargateConfig.withCqlOptionIntegerList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionIntegerListDC(String dc, TypedDriverOption<List<Integer>> option, List<Integer> du) {
        this.stargateConfig.withCqlOptionIntegerListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionLong(TypedDriverOption<Long> option, Long du) {
        this.stargateConfig.withCqlOptionLong(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionLongDC(String dc, TypedDriverOption<Long> option, Long du) {
        this.stargateConfig.withCqlOptionLongDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionLongList(TypedDriverOption<List<Long>> option, List<Long> du) {
        this.stargateConfig.withCqlOptionLongList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionLongListDC(String dc, TypedDriverOption<List<Long>> option, List<Long> du) {
        this.stargateConfig.withCqlOptionLongListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionString(TypedDriverOption<String> option, String du) {
        this.stargateConfig.withCqlOptionString(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionStringDC(String dc, TypedDriverOption<String> option, String du) {
        this.stargateConfig.withCqlOptionStringDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionStringList(TypedDriverOption<List<String>> option, List<String> du) {
        this.stargateConfig.withCqlOptionStringList(option, du);
        return this;
    }

    public AstraClientConfig withCqlOptionStringListDC(String dc, TypedDriverOption<List<String>> option, List<String> du) {
        this.stargateConfig.withCqlOptionStringListDC(dc, option, du);
        return this;
    }

    public AstraClientConfig withCqlMetricsRegistry(Object mr) {
        this.stargateConfig.withCqlMetricsRegistry(mr);
        return this;
    }

    public AstraClientConfig withCqlRequestTracker(RequestTracker rt) {
        this.stargateConfig.withCqlRequestTracker(rt);
        return this;
    }

    public AstraClientConfig withCqlSecureConnectBundleFolder(String scbPath) {
        Assert.hasLength((String)scbPath, (String)"scbPath");
        this.secureConnectBundleFolder = scbPath;
        return this;
    }

    public static String buildScbFileName(String dId, String dbRegion) {
        return "scb_" + dId + "_" + dbRegion + ".zip";
    }

    public AstraClientConfig() {
        LOGGER.info("Initializing [" + AnsiUtils.yellow((String)"AstraClient") + "]");
        this.stargateConfig = new StargateClientBuilder();
        if (AstraRc.isDefaultConfigFileExists()) {
            this.loadFromAstraRc();
        }
        Utils.readEnvVariable((String)"ASTRA_DB_APPLICATION_TOKEN").ifPresent(this::withToken);
        Utils.readEnvVariable((String)ASTRA_DB_CLIENT_ID).ifPresent(this::withClientId);
        Utils.readEnvVariable((String)ASTRA_DB_CLIENT_SECRET).ifPresent(this::withClientSecret);
        Utils.readEnvVariable((String)ASTRA_DB_ID).ifPresent(this::withDatabaseId);
        Utils.readEnvVariable((String)ASTRA_DB_REGION).ifPresent(this::withDatabaseRegion);
        Utils.readEnvVariable((String)ASTRA_DB_KEYSPACE).ifPresent(this::withCqlKeyspace);
        Utils.readEnvVariable((String)ASTRA_DB_SCB_FOLDER).ifPresent(this::withCqlSecureConnectBundleFolder);
    }

    public AstraClientConfig loadFromAstraRc() {
        AstraRc arc = new AstraRc();
        arc.getSectionKey("default", "ASTRA_DB_APPLICATION_TOKEN").ifPresent(this::withToken);
        arc.getSectionKey("default", ASTRA_DB_ID).ifPresent(this::withDatabaseId);
        arc.getSectionKey("default", ASTRA_DB_ID).ifPresent(this::withDatabaseId);
        arc.getSectionKey("default", ASTRA_DB_REGION).ifPresent(this::withDatabaseRegion);
        arc.getSectionKey("default", ASTRA_DB_CLIENT_ID).ifPresent(this::withClientId);
        arc.getSectionKey("default", ASTRA_DB_CLIENT_SECRET).ifPresent(this::withClientSecret);
        arc.getSectionKey("default", ASTRA_DB_KEYSPACE).ifPresent(this::withCqlKeyspace);
        arc.getSectionKey("default", ASTRA_DB_SCB_FOLDER).ifPresent(this::withCqlSecureConnectBundleFolder);
        return this;
    }

    public AstraClient build() {
        return new AstraClient(this);
    }
}

