/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.boot;

import com.datastax.astra.boot.AstraClientProperties;
import com.datastax.astra.boot.utils.DataStaxDriverSpringConfig;
import com.datastax.astra.boot.utils.SdkDriverConfigLoaderBuilderSpring;
import com.datastax.astra.sdk.AstraClient;
import com.datastax.astra.sdk.config.AstraClientConfig;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import io.micrometer.core.instrument.MeterRegistry;
import io.stargate.sdk.utils.Utils;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;

@AutoConfiguration
@ConditionalOnClass(value={AstraClient.class})
@EnableConfigurationProperties(value={AstraClientProperties.class})
public class AstraSpringBoot3AutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AstraSpringBoot3AutoConfiguration.class);
    @Autowired
    private AstraClientProperties astraClientProperties;
    @Autowired(required=false)
    private MeterRegistry microMeterMetricsRegistry;
    @Autowired
    private ConfigurableEnvironment env;

    @Bean
    @ConditionalOnMissingBean
    public AstraClient astraClient() {
        LOGGER.info("Setup of AstraClient from application.yaml");
        AstraClientConfig builder = AstraClient.builder();
        if (this.astraClientProperties.getApi() != null) {
            AstraClientProperties.Grpc grpc;
            LOGGER.debug("+ Api detected");
            AstraClientProperties.Api api = this.astraClientProperties.getApi();
            if (Utils.hasLength((String)api.getApplicationToken())) {
                builder.withToken(api.getApplicationToken());
                LOGGER.debug("+ Api /token detected {}...", (Object)api.getApplicationToken().substring(0, 10));
            }
            if (Utils.hasLength((String)api.getDatabaseId())) {
                builder.withDatabaseId(api.getDatabaseId());
                LOGGER.debug("+ Api /dbId detected {}", (Object)api.getDatabaseId());
            }
            if (Utils.hasLength((String)api.getDatabaseRegion())) {
                builder.withDatabaseRegion(api.getDatabaseRegion());
                LOGGER.debug("+ Api /dbRegion detected {}", (Object)api.getDatabaseRegion());
            }
            if (api.getCrossRegionFailback() == null || !api.getCrossRegionFailback().booleanValue()) {
                builder.disableCrossRegionFailOver();
                LOGGER.debug("+ Cross Region Failback is disabled");
            }
            if (api.getGrpc() != null && (grpc = api.getGrpc()).isEnabled()) {
                LOGGER.debug("+ Grpc is enabled");
                builder.enableGrpc();
            }
        }
        if (this.astraClientProperties.getCql() != null) {
            LOGGER.debug("+ Cql detected");
            AstraClientProperties.Cql cql = this.astraClientProperties.getCql();
            if (cql.isEnabled()) {
                LOGGER.debug("+ Cql is enabled");
                builder.enableCql();
                Map<String, String> properties = DataStaxDriverSpringConfig.driverConfigFromSpring(this.env);
                LOGGER.debug("+ Keys loaded {}", properties);
                SdkDriverConfigLoaderBuilderSpring driverConfig = new SdkDriverConfigLoaderBuilderSpring(properties);
                AstraClientProperties.DownloadSecureBundle dscb = cql.getDownloadScb();
                if (dscb != null && dscb.isEnabled()) {
                    LOGGER.info("+ Enabling SCB download into {}", (Object)dscb.getPath());
                    builder.enableDownloadSecureConnectBundle().withCqlSecureConnectBundleFolder(dscb.getPath());
                } else {
                    LOGGER.info("+ Load SCB locally from {}", (Object)dscb.getPath());
                    builder.disableDownloadSecureConnectBundle();
                    builder.secureConnectBundleFolder(dscb.getPath());
                }
                AstraClientProperties.Metrics metrics = cql.getMetrics();
                if (metrics != null && metrics.isEnabled() && null != this.microMeterMetricsRegistry) {
                    LOGGER.debug("+ Enabling CQL Metrics through Actuator");
                    driverConfig.withString((DriverOption)DefaultDriverOption.METRICS_FACTORY_CLASS, "MicrometerMetricsFactory");
                    driverConfig.withStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED, Stream.of(DefaultSessionMetric.values()).map(DefaultSessionMetric::getPath).collect(Collectors.toList()));
                    driverConfig.withStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED, Stream.of(DefaultSessionMetric.values()).map(DefaultSessionMetric::getPath).collect(Collectors.toList()));
                }
                builder.withCqlDriverConfig((ProgrammaticDriverConfigLoaderBuilder)driverConfig);
            }
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(prefix="astra.cql", name={"enabled"}, havingValue="true")
    public CqlSession cqlSession(AstraClient astraClient) {
        return astraClient.cqlSession();
    }
}

