/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.boot.utils;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;

public class DataStaxDriverSpringConfig {
    private static final String DRIVER_CONFIG_PREFIX = "astra.cql.driver-config";
    private static final String DRIVER_CONFIG_CORE = "datastax-java-driver";
    private static final Pattern TYPESAFE_LIST_PATTERN = Pattern.compile("(.+)\\[(\\d+)]");

    public static Map<String, String> driverConfigFromSpring(ConfigurableEnvironment env) {
        return Collections.unmodifiableMap(env.getPropertySources().stream().filter(EnumerablePropertySource.class::isInstance).map(EnumerablePropertySource.class::cast).flatMap(propertySource -> Arrays.stream(propertySource.getPropertyNames())).filter(key -> key.startsWith("astra.cql.driver-config.")).distinct().map(key -> new AbstractMap.SimpleEntry<String, String>(DataStaxDriverSpringConfig.mapAsTypeSafe(key), env.getProperty(key))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    }

    public static String mapAsTypeSafe(String key) {
        Matcher matcher = TYPESAFE_LIST_PATTERN.matcher(key);
        if (matcher.matches()) {
            key = String.format("%s.%s", matcher.group(1), matcher.group(2));
        }
        key = key.replace(DRIVER_CONFIG_PREFIX, DRIVER_CONFIG_CORE);
        return key;
    }
}

