/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.auth;

import com.datastax.driver.auth.BaseDseAuthenticator;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class DseGSSAPIAuthProvider
implements AuthProvider {
    public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
        return new GSSAPIAuthenticator(authenticator, host);
    }

    private static class GSSAPIAuthenticator
    extends BaseDseAuthenticator {
        private static final String JAAS_CONFIG_ENTRY = "DseClient";
        private static final String[] SUPPORTED_MECHANISMS = new String[]{"GSSAPI"};
        private static final String SASL_PROTOCOL_NAME = "dse";
        private static final String SASL_PROTOCOL_NAME_PROPERTY = "dse.sasl.protocol";
        private static final Map<String, String> DEFAULT_PROPERTIES = ImmutableMap.builder().put((Object)"javax.security.sasl.server.authentication", (Object)"true").put((Object)"javax.security.sasl.qop", (Object)"auth").build();
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private static final byte[] MECHANISM = "GSSAPI".getBytes(Charsets.UTF_8);
        private static final byte[] SERVER_INITIAL_CHALLENGE = "GSSAPI-START".getBytes(Charsets.UTF_8);
        private final Subject subject;
        private final SaslClient saslClient;

        public GSSAPIAuthenticator(String authenticator, InetSocketAddress host) {
            super(authenticator);
            try {
                LoginContext login = new LoginContext(JAAS_CONFIG_ENTRY);
                login.login();
                this.subject = login.getSubject();
                this.saslClient = Sasl.createSaslClient(SUPPORTED_MECHANISMS, null, System.getProperty(SASL_PROTOCOL_NAME_PROPERTY, SASL_PROTOCOL_NAME), host.getAddress().getCanonicalHostName(), DEFAULT_PROPERTIES, null);
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] getMechanism() {
            return (byte[])MECHANISM.clone();
        }

        @Override
        public byte[] getInitialServerChallenge() {
            return (byte[])SERVER_INITIAL_CHALLENGE.clone();
        }

        public byte[] evaluateChallenge(byte[] challenge) {
            if (Arrays.equals(SERVER_INITIAL_CHALLENGE, challenge)) {
                if (!this.saslClient.hasInitialResponse()) {
                    return EMPTY_BYTE_ARRAY;
                }
                challenge = EMPTY_BYTE_ARRAY;
            }
            final byte[] internalChallenge = challenge;
            try {
                return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return GSSAPIAuthenticator.this.saslClient.evaluateChallenge(internalChallenge);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getException());
            }
        }
    }
}

