/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.auth;

import com.datastax.driver.auth.BaseDseAuthenticator;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Arrays;

public class DsePlainTextAuthProvider
implements AuthProvider {
    private final String username;
    private final String password;

    public DsePlainTextAuthProvider(String username, String password) {
        Preconditions.checkNotNull((Object)username, (Object)"username cannot be null");
        Preconditions.checkNotNull((Object)password, (Object)"password cannot be null");
        this.username = username;
        this.password = password;
    }

    public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
        return new PlainTextAuthenticator(authenticator, this.username, this.password);
    }

    private static class PlainTextAuthenticator
    extends BaseDseAuthenticator {
        private static final byte[] MECHANISM = "PLAIN".getBytes(Charsets.UTF_8);
        private static final byte[] SERVER_INITIAL_CHALLENGE = "PLAIN-START".getBytes(Charsets.UTF_8);
        private final byte[] username;
        private final byte[] password;

        public PlainTextAuthenticator(String authenticator, String username, String password) {
            super(authenticator);
            this.username = username.getBytes(Charsets.UTF_8);
            this.password = password.getBytes(Charsets.UTF_8);
        }

        @Override
        public byte[] getMechanism() {
            return (byte[])MECHANISM.clone();
        }

        @Override
        public byte[] getInitialServerChallenge() {
            return (byte[])SERVER_INITIAL_CHALLENGE.clone();
        }

        public byte[] evaluateChallenge(byte[] challenge) {
            if (Arrays.equals(SERVER_INITIAL_CHALLENGE, challenge)) {
                byte[] token = new byte[this.username.length + this.password.length + 2];
                token[0] = 0;
                System.arraycopy(this.username, 0, token, 1, this.username.length);
                token[this.username.length + 1] = 0;
                System.arraycopy(this.password, 0, token, this.username.length + 2, this.password.length);
                return token;
            }
            throw new RuntimeException("Incorrect challenge from server");
        }
    }
}

