/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.MethodMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;

abstract class AccessorMapper<T> {
    public final Class<T> daoClass;
    protected final List<MethodMapper> methods;

    protected AccessorMapper(Class<T> daoClass, List<MethodMapper> methods) {
        this.daoClass = daoClass;
        this.methods = methods;
    }

    abstract T createProxy();

    public void prepare(MappingManager manager) {
        ArrayList<ListenableFuture> statements = new ArrayList<ListenableFuture>(this.methods.size());
        for (MethodMapper method : this.methods) {
            statements.add(manager.getSession().prepareAsync(method.queryString));
        }
        try {
            List preparedStatements = (List)Futures.allAsList(statements).get();
            for (int i = 0; i < this.methods.size(); ++i) {
                this.methods.get(i).prepare(manager, (PreparedStatement)preparedStatements.get(i));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error preparing queries for accessor " + this.daoClass.getSimpleName(), e);
        }
    }

    static interface Factory {
        public <T> AccessorMapper<T> create(Class<T> var1, List<MethodMapper> var2);
    }
}

