/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.MoreObjects;
import com.datastax.driver.mapping.AliasedMappedProperty;
import com.datastax.driver.mapping.DriverThrowables;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MapperBoundStatement;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.QueryType;
import com.datastax.driver.mapping.Result;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(Mapper.class);
    private static final Function<Object, Void> TO_NULL = Functions.constant(null);
    private final MappingManager manager;
    private final Class<T> klass;
    private final EntityMapper<T> mapper;
    private final TableMetadata tableMetadata;
    private final ConcurrentMap<MapperQueryKey, ListenableFuture<PreparedStatement>> preparedQueries = new ConcurrentHashMap<MapperQueryKey, ListenableFuture<PreparedStatement>>();
    private volatile EnumMap<Option.Type, Option> defaultSaveOptions;
    private volatile EnumMap<Option.Type, Option> defaultGetOptions;
    private volatile EnumMap<Option.Type, Option> defaultDeleteOptions;
    private static final EnumMap<Option.Type, Option> NO_OPTIONS = new EnumMap(Option.Type.class);
    private final Function<ResultSet, T> mapOneFunction;
    final Function<ResultSet, T> mapOneFunctionWithoutAliases;
    final Function<ResultSet, Result<T>> mapAllFunctionWithoutAliases;

    Mapper(MappingManager manager, Class<T> klass, EntityMapper<T> mapper) {
        this.manager = manager;
        this.klass = klass;
        this.mapper = mapper;
        KeyspaceMetadata keyspace = this.session().getCluster().getMetadata().getKeyspace(mapper.keyspace);
        this.tableMetadata = keyspace == null ? null : keyspace.getTable(mapper.table);
        this.mapOneFunction = new Function<ResultSet, T>(){

            public T apply(ResultSet rs) {
                return Mapper.this.map(rs).one();
            }
        };
        this.mapOneFunctionWithoutAliases = new Function<ResultSet, T>(){

            public T apply(ResultSet rs) {
                return Mapper.this.map(rs).one();
            }
        };
        this.mapAllFunctionWithoutAliases = new Function<ResultSet, Result<T>>(){

            public Result<T> apply(ResultSet rs) {
                return Mapper.this.map(rs);
            }
        };
        this.defaultSaveOptions = NO_OPTIONS;
        this.defaultGetOptions = NO_OPTIONS;
        this.defaultDeleteOptions = NO_OPTIONS;
    }

    Session session() {
        return this.manager.getSession();
    }

    ListenableFuture<PreparedStatement> getPreparedQueryAsync(QueryType type, Set<AliasedMappedProperty> columns, EnumMap<Option.Type, Option> options) {
        final MapperQueryKey pqk = new MapperQueryKey(type, columns, options);
        ListenableFuture existingFuture = (ListenableFuture)this.preparedQueries.get(pqk);
        if (existingFuture == null) {
            final SettableFuture future = SettableFuture.create();
            ListenableFuture<PreparedStatement> old = this.preparedQueries.putIfAbsent(pqk, (ListenableFuture<PreparedStatement>)future);
            if (old != null) {
                return old;
            }
            final String queryString = type.makePreparedQueryString(this.tableMetadata, this.mapper, this.manager, columns, options.values());
            logger.debug("Preparing query {}", (Object)queryString);
            SimpleStatement s = new SimpleStatement(queryString);
            s.setIdempotent(true);
            Futures.addCallback((ListenableFuture)this.session().prepareAsync((RegularStatement)s), (FutureCallback)new FutureCallback<PreparedStatement>(){

                public void onSuccess(PreparedStatement stmt) {
                    future.set((Object)stmt);
                }

                public void onFailure(Throwable t) {
                    future.setException(t);
                    Mapper.this.preparedQueries.remove(pqk, future);
                    logger.error("Query preparation failed: " + queryString, t);
                }
            });
            return future;
        }
        return existingFuture;
    }

    ListenableFuture<PreparedStatement> getPreparedQueryAsync(QueryType type, EnumMap<Option.Type, Option> options) {
        return this.getPreparedQueryAsync(type, Collections.<AliasedMappedProperty>emptySet(), options);
    }

    Class<T> getMappedClass() {
        return this.klass;
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public MappingManager getManager() {
        return this.manager;
    }

    public Statement saveQuery(T entity) {
        this.checkNotInEventLoop();
        try {
            return (Statement)Uninterruptibles.getUninterruptibly(this.saveQueryAsync(entity, this.defaultSaveOptions));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Statement saveQuery(T entity, Option ... options) {
        this.checkNotInEventLoop();
        try {
            return (Statement)Uninterruptibles.getUninterruptibly(this.saveQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultSaveOptions)));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    private ListenableFuture<BoundStatement> saveQueryAsync(T entity, final EnumMap<Option.Type, Option> options) {
        final HashMap<AliasedMappedProperty, Object> columnToValue = new HashMap<AliasedMappedProperty, Object>();
        final boolean useUnsetForNullValue = !Mapper.shouldSaveNullFields(options) && this.manager.protocolVersionAsInt >= 4;
        boolean includeColumnsWithNullValue = Mapper.shouldSaveNullFields(options) || useUnsetForNullValue;
        for (AliasedMappedProperty col : this.mapper.allColumns) {
            Object value = col.mappedProperty.getValue(entity);
            if (col.mappedProperty.isComputed() || !includeColumnsWithNullValue && value == null) continue;
            columnToValue.put(col, value);
        }
        return Futures.transform(this.getPreparedQueryAsync(QueryType.SAVE, columnToValue.keySet(), options), (Function)new Function<PreparedStatement, BoundStatement>(){

            public BoundStatement apply(PreparedStatement input) {
                BoundStatement bs = input.bind();
                int i = 0;
                for (Map.Entry entry : columnToValue.entrySet()) {
                    AliasedMappedProperty mapper = (AliasedMappedProperty)entry.getKey();
                    Object value = entry.getValue();
                    Mapper.setObject(bs, i++, value, mapper, useUnsetForNullValue);
                }
                if (((Mapper)Mapper.this).mapper.writeConsistency != null) {
                    bs.setConsistencyLevel(((Mapper)Mapper.this).mapper.writeConsistency);
                }
                for (Option option : options.values()) {
                    option.validate(QueryType.SAVE, Mapper.this.manager);
                    i = option.apply(bs, i);
                }
                return bs;
            }
        });
    }

    private static boolean shouldSaveNullFields(EnumMap<Option.Type, Option> options) {
        Option.SaveNullFields option = (Option.SaveNullFields)options.get((Object)Option.Type.SAVE_NULL_FIELDS);
        return option == null || option.saveNullFields;
    }

    private static <T> void setObject(BoundStatement bs, int i, T value, AliasedMappedProperty mapper, boolean saveNullFieldsAsUnset) {
        TypeCodec<Object> customCodec = mapper.mappedProperty.getCustomCodec();
        if (saveNullFieldsAsUnset && value == null) {
            bs.unset(i);
        } else if (customCodec != null) {
            bs.set(i, value, customCodec);
        } else {
            bs.set(i, value, mapper.mappedProperty.getPropertyType());
        }
    }

    public void save(T entity) {
        this.checkNotInEventLoop();
        try {
            Uninterruptibles.getUninterruptibly(this.saveAsync(entity));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public void save(T entity, Option ... options) {
        this.checkNotInEventLoop();
        try {
            Uninterruptibles.getUninterruptibly(this.saveAsync(entity, options));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Void> saveAsync(T entity) {
        return this.submitVoidQueryAsync(this.saveQueryAsync(entity, this.defaultSaveOptions));
    }

    public ListenableFuture<Void> saveAsync(T entity, Option ... options) {
        return this.submitVoidQueryAsync(this.saveQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultSaveOptions)));
    }

    private ListenableFuture<Void> submitVoidQueryAsync(ListenableFuture<BoundStatement> bsFuture) {
        ListenableFuture rsFuture = GuavaCompatibility.INSTANCE.transformAsync(bsFuture, (AsyncFunction)new AsyncFunction<BoundStatement, ResultSet>(){

            public ListenableFuture<ResultSet> apply(BoundStatement bs) throws Exception {
                return Mapper.this.session().executeAsync((Statement)bs);
            }
        });
        return Futures.transform((ListenableFuture)rsFuture, TO_NULL);
    }

    public Statement getQuery(Object ... objects) {
        this.checkNotInEventLoop();
        try {
            return (Statement)Uninterruptibles.getUninterruptibly(this.getQueryAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    private ListenableFuture<BoundStatement> getQueryAsync(Object ... objects) {
        ArrayList<Object> pks = new ArrayList<Object>();
        EnumMap<Option.Type, Option> options = new EnumMap<Option.Type, Option>(this.defaultGetOptions);
        for (Object o : objects) {
            if (o instanceof Option) {
                Option option = (Option)o;
                options.put(option.type, option);
                continue;
            }
            pks.add(o);
        }
        return this.getQueryAsync(pks, options);
    }

    private ListenableFuture<BoundStatement> getQueryAsync(final List<Object> primaryKeys, final EnumMap<Option.Type, Option> options) {
        if (primaryKeys.size() != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKeys.size()));
        }
        return Futures.transform(this.getPreparedQueryAsync(QueryType.GET, options), (Function)new Function<PreparedStatement, BoundStatement>(){

            public BoundStatement apply(PreparedStatement input) {
                MapperBoundStatement bs = new MapperBoundStatement(input);
                int i = 0;
                for (Object value : primaryKeys) {
                    AliasedMappedProperty column = Mapper.this.mapper.getPrimaryKeyColumn(i);
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.mappedProperty.getMappedName(), i));
                    }
                    Mapper.setObject(bs, i++, value, column, false);
                }
                if (((Mapper)Mapper.this).mapper.readConsistency != null) {
                    bs.setConsistencyLevel(((Mapper)Mapper.this).mapper.readConsistency);
                }
                for (Option option : options.values()) {
                    option.validate(QueryType.GET, Mapper.this.manager);
                    i = option.apply(bs, i);
                }
                return bs;
            }
        });
    }

    public T get(Object ... objects) {
        this.checkNotInEventLoop();
        try {
            return (T)Uninterruptibles.getUninterruptibly(this.getAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<T> getAsync(Object ... objects) {
        ListenableFuture<BoundStatement> bsFuture = this.getQueryAsync(objects);
        ListenableFuture rsFuture = GuavaCompatibility.INSTANCE.transformAsync(bsFuture, (AsyncFunction)new AsyncFunction<BoundStatement, ResultSet>(){

            public ListenableFuture<ResultSet> apply(BoundStatement bs) throws Exception {
                return Mapper.this.session().executeAsync((Statement)bs);
            }
        });
        return Futures.transform((ListenableFuture)rsFuture, this.mapOneFunction);
    }

    public Statement deleteQuery(T entity, Option ... options) {
        this.checkNotInEventLoop();
        try {
            return (Statement)Uninterruptibles.getUninterruptibly(this.deleteQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultDeleteOptions)));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Statement deleteQuery(T entity) {
        this.checkNotInEventLoop();
        try {
            return (Statement)Uninterruptibles.getUninterruptibly(this.deleteQueryAsync(entity, this.defaultDeleteOptions));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Statement deleteQuery(Object ... objects) {
        this.checkNotInEventLoop();
        try {
            return (Statement)Uninterruptibles.getUninterruptibly(this.deleteQueryAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    private ListenableFuture<BoundStatement> deleteQueryAsync(T entity, EnumMap<Option.Type, Option> options) {
        ArrayList<Object> pks = new ArrayList<Object>();
        for (int i = 0; i < this.mapper.primaryKeySize(); ++i) {
            pks.add(this.mapper.getPrimaryKeyColumn((int)i).mappedProperty.getValue(entity));
        }
        return this.deleteQueryAsync((List<Object>)pks, options);
    }

    private ListenableFuture<BoundStatement> deleteQueryAsync(Object ... objects) {
        ArrayList<Object> pks = new ArrayList<Object>();
        EnumMap<Option.Type, Option> options = new EnumMap<Option.Type, Option>(this.defaultDeleteOptions);
        for (Object o : objects) {
            if (o instanceof Option) {
                Option option = (Option)o;
                options.put(option.type, option);
                continue;
            }
            pks.add(o);
        }
        return this.deleteQueryAsync((List<Object>)pks, options);
    }

    private ListenableFuture<BoundStatement> deleteQueryAsync(final List<Object> primaryKey, final EnumMap<Option.Type, Option> options) {
        if (primaryKey.size() != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKey.size()));
        }
        return Futures.transform(this.getPreparedQueryAsync(QueryType.DEL, options), (Function)new Function<PreparedStatement, BoundStatement>(){

            public BoundStatement apply(PreparedStatement input) {
                BoundStatement bs = input.bind();
                if (((Mapper)Mapper.this).mapper.writeConsistency != null) {
                    bs.setConsistencyLevel(((Mapper)Mapper.this).mapper.writeConsistency);
                }
                int i = 0;
                for (Option option : options.values()) {
                    option.validate(QueryType.DEL, Mapper.this.manager);
                    i = option.apply(bs, i);
                }
                int columnNumber = 0;
                for (Object value : primaryKey) {
                    AliasedMappedProperty column = Mapper.this.mapper.getPrimaryKeyColumn(columnNumber);
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.mappedProperty.getMappedName(), i));
                    }
                    Mapper.setObject(bs, i++, value, column, false);
                    ++columnNumber;
                }
                return bs;
            }
        });
    }

    public void delete(T entity) {
        this.checkNotInEventLoop();
        try {
            Uninterruptibles.getUninterruptibly(this.deleteAsync(entity));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public void delete(T entity, Option ... options) {
        this.checkNotInEventLoop();
        try {
            Uninterruptibles.getUninterruptibly(this.deleteAsync(entity, options));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Void> deleteAsync(T entity) {
        return this.submitVoidQueryAsync(this.deleteQueryAsync(entity, this.defaultDeleteOptions));
    }

    public ListenableFuture<Void> deleteAsync(T entity, Option ... options) {
        return this.submitVoidQueryAsync(this.deleteQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultDeleteOptions)));
    }

    public void delete(Object ... objects) {
        this.checkNotInEventLoop();
        try {
            Uninterruptibles.getUninterruptibly(this.deleteAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Void> deleteAsync(Object ... objects) {
        return this.submitVoidQueryAsync(this.deleteQueryAsync(objects));
    }

    public Result<T> map(ResultSet resultSet) {
        boolean useAlias = this.manager.protocolVersionAsInt > 1 && this.isFromMapperQuery(resultSet);
        return new Result<T>(resultSet, this.mapper, useAlias);
    }

    public ListenableFuture<Result<T>> mapAsync(ResultSetFuture resultSetFuture) {
        return Futures.transform((ListenableFuture)resultSetFuture, (Function)new Function<ResultSet, Result<T>>(){

            public Result<T> apply(ResultSet rs) {
                return Mapper.this.map(rs);
            }
        });
    }

    private boolean isFromMapperQuery(ResultSet resultSet) {
        return resultSet.getExecutionInfo().getStatement() instanceof MapperBoundStatement;
    }

    @Deprecated
    public Result<T> mapAliased(ResultSet resultSet) {
        return this.manager.protocolVersionAsInt == 1 ? this.map(resultSet) : new Result<T>(resultSet, this.mapper, true);
    }

    public void setDefaultSaveOptions(Option ... options) {
        this.defaultSaveOptions = Mapper.toMap(options);
    }

    public void resetDefaultSaveOptions() {
        this.defaultSaveOptions = NO_OPTIONS;
    }

    public void setDefaultGetOptions(Option ... options) {
        this.defaultGetOptions = Mapper.toMap(options);
    }

    public void resetDefaultGetOptions() {
        this.defaultGetOptions = NO_OPTIONS;
    }

    public void setDefaultDeleteOptions(Option ... options) {
        this.defaultDeleteOptions = Mapper.toMap(options);
    }

    public void resetDefaultDeleteOptions() {
        this.defaultDeleteOptions = NO_OPTIONS;
    }

    private static EnumMap<Option.Type, Option> toMap(Option[] options) {
        EnumMap<Option.Type, Option> result = new EnumMap<Option.Type, Option>(Option.Type.class);
        for (Option option : options) {
            result.put(option.type, option);
        }
        return result;
    }

    private static EnumMap<Option.Type, Option> toMapWithDefaults(Option[] options, EnumMap<Option.Type, Option> defaults) {
        EnumMap<Option.Type, Option> result = new EnumMap<Option.Type, Option>(defaults);
        for (Option option : options) {
            result.put(option.type, option);
        }
        return result;
    }

    private void checkNotInEventLoop() {
        Session session = this.manager.getSession();
        if (session instanceof AbstractSession) {
            ((AbstractSession)session).checkNotInEventLoop();
        }
    }

    private static class MapperQueryKey {
        private final QueryType queryType;
        private final Set<Object> optionKeys;
        private final Set<AliasedMappedProperty> columns;

        MapperQueryKey(QueryType queryType, Set<AliasedMappedProperty> aliasedMappedProperties, EnumMap<Option.Type, Option> allOptions) {
            Preconditions.checkNotNull((Object)((Object)queryType));
            Preconditions.checkNotNull(allOptions);
            Preconditions.checkNotNull(aliasedMappedProperties);
            this.queryType = queryType;
            this.columns = aliasedMappedProperties;
            ImmutableSet.Builder optionKeysBuilder = ImmutableSet.builder();
            for (Option option : allOptions.values()) {
                if (!option.modifiesQueryString()) continue;
                optionKeysBuilder.add(option.asCacheKey());
            }
            this.optionKeys = optionKeysBuilder.build();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof MapperQueryKey) {
                MapperQueryKey that = (MapperQueryKey)other;
                return this.queryType.equals((Object)that.queryType) && this.optionKeys.equals(that.optionKeys) && this.columns.equals(that.columns);
            }
            return false;
        }

        public int hashCode() {
            return MoreObjects.hashCode((Object[])new Object[]{this.queryType, this.optionKeys, this.columns});
        }
    }

    public static abstract class Option {
        final Type type;

        public static Option ttl(int ttl) {
            return new Ttl(ttl);
        }

        public static Option timestamp(long timestamp) {
            return new Timestamp(timestamp);
        }

        public static Option consistencyLevel(ConsistencyLevel cl) {
            return new ConsistencyLevelOption(cl);
        }

        public static Option tracing(boolean enabled) {
            return new Tracing(enabled);
        }

        public static Option saveNullFields(boolean enabled) {
            return new SaveNullFields(enabled);
        }

        public static Option ifNotExists(boolean enabled) {
            return new IfNotExists(enabled);
        }

        protected Option(Type type) {
            this.type = type;
        }

        @Deprecated
        public Type getType() {
            return this.type;
        }

        abstract void validate(QueryType var1, MappingManager var2);

        abstract boolean modifiesQueryString();

        abstract void modifyQueryString(BuiltStatement var1);

        abstract int apply(BoundStatement var1, int var2);

        abstract Object asCacheKey();

        static class IfNotExists
        extends Option {
            boolean ifNotExists;

            IfNotExists(boolean ifNotExists) {
                super(Type.IF_NOT_EXISTS);
                this.ifNotExists = ifNotExists;
            }

            @Override
            void validate(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((qt == QueryType.SAVE ? 1 : 0) != 0, (Object)"IfNotExists option is only allowed in save queries");
            }

            @Override
            boolean modifiesQueryString() {
                return true;
            }

            @Override
            void modifyQueryString(BuiltStatement query) {
                if (this.ifNotExists) {
                    ((Insert)query).ifNotExists();
                }
            }

            @Override
            int apply(BoundStatement bs, int currentIndex) {
                return currentIndex;
            }

            @Override
            Object asCacheKey() {
                return this;
            }

            public boolean equals(Object other) {
                return other == this || other instanceof IfNotExists && this.ifNotExists == ((IfNotExists)other).ifNotExists;
            }

            public int hashCode() {
                return this.ifNotExists ? 1231 : 1237;
            }
        }

        static class SaveNullFields
        extends Option {
            private final boolean saveNullFields;

            SaveNullFields(boolean saveNullFields) {
                super(Type.SAVE_NULL_FIELDS);
                this.saveNullFields = saveNullFields;
            }

            @Override
            void validate(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((qt == QueryType.SAVE ? 1 : 0) != 0, (Object)"SaveNullFields option is only allowed in save queries");
            }

            @Override
            boolean modifiesQueryString() {
                return false;
            }

            @Override
            void modifyQueryString(BuiltStatement query) {
            }

            @Override
            int apply(BoundStatement bs, int currentIndex) {
                return currentIndex;
            }

            @Override
            Object asCacheKey() {
                return Type.SAVE_NULL_FIELDS;
            }

            public boolean equals(Object other) {
                return other == this || other instanceof SaveNullFields && this.saveNullFields == ((SaveNullFields)other).saveNullFields;
            }

            public int hashCode() {
                return this.saveNullFields ? 1231 : 1237;
            }
        }

        static class Tracing
        extends Option {
            private final boolean tracing;

            Tracing(boolean tracing) {
                super(Type.TRACING);
                this.tracing = tracing;
            }

            @Override
            void validate(QueryType qt, MappingManager manager) {
            }

            @Override
            boolean modifiesQueryString() {
                return false;
            }

            @Override
            void modifyQueryString(BuiltStatement query) {
            }

            @Override
            int apply(BoundStatement bs, int currentIndex) {
                if (this.tracing) {
                    bs.enableTracing();
                }
                return currentIndex;
            }

            @Override
            Object asCacheKey() {
                return Type.TRACING;
            }

            public boolean equals(Object other) {
                return other == this || other instanceof Tracing && this.tracing == ((Tracing)other).tracing;
            }

            public int hashCode() {
                return this.tracing ? 1231 : 1237;
            }
        }

        static class ConsistencyLevelOption
        extends Option {
            private final ConsistencyLevel cl;

            ConsistencyLevelOption(ConsistencyLevel cl) {
                super(Type.CL);
                this.cl = cl;
            }

            @Override
            void validate(QueryType qt, MappingManager manager) {
            }

            @Override
            boolean modifiesQueryString() {
                return false;
            }

            @Override
            void modifyQueryString(BuiltStatement query) {
            }

            @Override
            int apply(BoundStatement bs, int currentIndex) {
                bs.setConsistencyLevel(this.cl);
                return currentIndex;
            }

            @Override
            Object asCacheKey() {
                return Type.CL;
            }

            public boolean equals(Object other) {
                return other == this || other instanceof ConsistencyLevelOption && this.cl == ((ConsistencyLevelOption)other).cl;
            }

            public int hashCode() {
                return this.cl.hashCode();
            }
        }

        static class Timestamp
        extends Option {
            private final long tsValue;

            Timestamp(long value) {
                super(Type.TIMESTAMP);
                this.tsValue = value;
            }

            @Override
            void validate(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((manager.protocolVersionAsInt >= 2 ? 1 : 0) != 0, (Object)"Timestamp option requires native protocol v2 or above");
                Preconditions.checkArgument((qt == QueryType.SAVE || qt == QueryType.DEL ? 1 : 0) != 0, (Object)"Timestamp option is only allowed in save and delete queries");
            }

            @Override
            boolean modifiesQueryString() {
                return true;
            }

            @Override
            void modifyQueryString(BuiltStatement query) {
                if (query instanceof Insert) {
                    ((Insert)query).using().and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
                } else if (query instanceof Delete) {
                    ((Delete)query).using().and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
                } else {
                    throw new AssertionError((Object)("Unexpected query type: " + query.getClass()));
                }
            }

            @Override
            int apply(BoundStatement bs, int currentIndex) {
                bs.setLong(currentIndex, this.tsValue);
                return currentIndex + 1;
            }

            @Override
            Object asCacheKey() {
                return Type.TIMESTAMP;
            }

            public boolean equals(Object other) {
                return other == this || other instanceof Timestamp && this.tsValue == ((Timestamp)other).tsValue;
            }

            public int hashCode() {
                return (int)(this.tsValue ^ this.tsValue >>> 32);
            }
        }

        static class Ttl
        extends Option {
            private final int ttlValue;

            Ttl(int value) {
                super(Type.TTL);
                this.ttlValue = value;
            }

            @Override
            void validate(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument((manager.protocolVersionAsInt >= 2 ? 1 : 0) != 0, (Object)"TTL option requires native protocol v2 or above");
                Preconditions.checkArgument((qt == QueryType.SAVE ? 1 : 0) != 0, (Object)"TTL option is only allowed in save queries");
            }

            @Override
            boolean modifiesQueryString() {
                return true;
            }

            @Override
            void modifyQueryString(BuiltStatement query) {
                ((Insert)query).using().and(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker()));
            }

            @Override
            int apply(BoundStatement bs, int currentIndex) {
                bs.setInt(currentIndex, this.ttlValue);
                return currentIndex + 1;
            }

            @Override
            Object asCacheKey() {
                return Type.TTL;
            }

            public boolean equals(Object other) {
                return other == this || other instanceof Ttl && this.ttlValue == ((Ttl)other).ttlValue;
            }

            public int hashCode() {
                return this.ttlValue;
            }
        }

        static enum Type {
            TTL,
            TIMESTAMP,
            CL,
            TRACING,
            SAVE_NULL_FIELDS,
            IF_NOT_EXISTS;

        }
    }
}

