/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.dse.DriverThrowables;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.HostTargetingStatement;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDseSession
implements DseSession {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDseSession.class);
    private static final String ANALYTICS_GRAPH_SOURCE = "a";
    private static final Statement LOOKUP_ANALYTICS_GRAPH_SERVER = new SimpleStatement("CALL DseClientTool.getAnalyticsGraphServer()");
    private final Session delegate;
    private final DseCluster dseCluster;

    DefaultDseSession(Session delegate, DseCluster dseCluster) {
        this.delegate = delegate;
        this.dseCluster = dseCluster;
    }

    @Override
    public DseSession init() {
        try {
            return (DseSession)Uninterruptibles.getUninterruptibly(this.initAsync());
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<Session> initAsync() {
        return Futures.transform((ListenableFuture)this.delegate.initAsync(), (Function)new Function<Session, Session>(){

            public Session apply(Session input) {
                return DefaultDseSession.this;
            }
        });
    }

    @Override
    public GraphResultSet executeGraph(String query) {
        return this.executeGraph(new SimpleGraphStatement(query));
    }

    @Override
    public GraphResultSet executeGraph(String query, Map<String, Object> values) {
        return this.executeGraph(new SimpleGraphStatement(query, values));
    }

    @Override
    public GraphResultSet executeGraph(GraphStatement statement) {
        try {
            return (GraphResultSet)Uninterruptibles.getUninterruptibly(this.executeGraphAsync(statement));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<GraphResultSet> executeGraphAsync(String query) {
        return this.executeGraphAsync(new SimpleGraphStatement(query));
    }

    @Override
    public ListenableFuture<GraphResultSet> executeGraphAsync(String query, Map<String, Object> values) {
        return this.executeGraphAsync(new SimpleGraphStatement(query, values));
    }

    @Override
    public ListenableFuture<GraphResultSet> executeGraphAsync(final GraphStatement graphStatement) {
        final Statement statement = DefaultDseSession.generateCoreStatement(this.dseCluster.getConfiguration().getGraphOptions(), graphStatement);
        if (ANALYTICS_GRAPH_SOURCE.equals(graphStatement.getGraphSource())) {
            ListenableFuture serverLocation = Futures.withFallback((ListenableFuture)this.delegate.executeAsync(LOOKUP_ANALYTICS_GRAPH_SERVER), (FutureFallback)new FutureFallback<ResultSet>(){

                public ListenableFuture<ResultSet> create(Throwable t) throws Exception {
                    logger.debug("Error querying graph analytics server, query will not be routed optimally", t);
                    return null;
                }
            });
            return Futures.transform((ListenableFuture)serverLocation, (AsyncFunction)new AsyncFunction<ResultSet, GraphResultSet>(){

                public ListenableFuture<GraphResultSet> apply(ResultSet rs) throws Exception {
                    Host analyticsServer = rs == null ? null : DefaultDseSession.this.extractHostFromAnalyticsServerQuery(rs);
                    Object targetedStatement = analyticsServer == null ? statement : new HostTargetingStatement(statement, analyticsServer);
                    return Futures.transform((ListenableFuture)DefaultDseSession.this.delegate.executeAsync(targetedStatement), (Function)new Function<ResultSet, GraphResultSet>(){

                        public GraphResultSet apply(ResultSet input) {
                            return new GraphResultSet(input, graphStatement.getTransformResultFunction());
                        }
                    });
                }
            });
        }
        return Futures.transform((ListenableFuture)this.delegate.executeAsync(statement), (Function)new Function<ResultSet, GraphResultSet>(){

            public GraphResultSet apply(ResultSet input) {
                return new GraphResultSet(input, graphStatement.getTransformResultFunction());
            }
        });
    }

    private Host extractHostFromAnalyticsServerQuery(ResultSet rs) {
        if (rs.isExhausted()) {
            logger.debug("Empty response querying graph analytics server, query will not be routed optimally");
            return null;
        }
        try {
            Map result = rs.one().getMap("result", String.class, String.class);
            if (result != null && result.containsKey("location")) {
                String location = (String)result.get("location");
                String hostName = location.substring(0, location.lastIndexOf(":"));
                AddressTranslator addressTranslator = this.dseCluster.getConfiguration().getPolicies().getAddressTranslator();
                int port = this.dseCluster.getConfiguration().getProtocolOptions().getPort();
                InetSocketAddress broadcastRpcAddress = addressTranslator.translate(new InetSocketAddress(hostName, port));
                for (Host host : this.dseCluster.getMetadata().getAllHosts()) {
                    if (!host.getSocketAddress().equals(broadcastRpcAddress)) continue;
                    logger.debug("Routing analytics query to {}", (Object)host);
                    return host;
                }
                logger.debug("Could not find host matching graph analytics server {}, query will not be routed optimally", (Object)broadcastRpcAddress);
                return null;
            }
            logger.debug("Could not extract graph analytics server location from '{}', query will not be routed optimally", (Object)result);
            return null;
        }
        catch (Exception e) {
            logger.debug("Error while processing graph analytics server location, query will not be routed optimally", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static Statement generateCoreStatement(GraphOptions graphOptions, GraphStatement graphStatement) {
        Boolean idempotent;
        Statement statement = graphStatement.unwrap();
        statement.setOutgoingPayload(graphOptions.buildPayloadWithDefaults(graphStatement));
        if (statement.getReadTimeoutMillis() == Integer.MIN_VALUE) {
            statement.setReadTimeoutMillis(graphOptions.getReadTimeoutMillis());
        }
        if ((idempotent = graphStatement.isIdempotent()) != null) {
            statement.setIdempotent(idempotent.booleanValue());
        }
        return statement;
    }

    @Override
    public DseCluster getCluster() {
        return this.dseCluster;
    }

    @Override
    public String getLoggedKeyspace() {
        return this.delegate.getLoggedKeyspace();
    }

    public CloseFuture closeAsync() {
        return this.delegate.closeAsync();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public Session.State getState() {
        return this.delegate.getState();
    }

    public ResultSetFuture executeAsync(Statement statement) {
        return this.delegate.executeAsync(statement);
    }

    public ResultSet execute(String query) {
        return this.delegate.execute(query);
    }

    public ResultSet execute(String query, Object ... values) {
        return this.delegate.execute(query, values);
    }

    public ResultSet execute(String query, Map<String, Object> values) {
        return this.delegate.execute(query, values);
    }

    public ResultSet execute(Statement statement) {
        return this.delegate.execute(statement);
    }

    public ResultSetFuture executeAsync(String query) {
        return this.delegate.executeAsync(query);
    }

    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.delegate.executeAsync(query, values);
    }

    public ResultSetFuture executeAsync(String query, Map<String, Object> values) {
        return this.delegate.executeAsync(query, values);
    }

    public PreparedStatement prepare(String query) {
        return this.delegate.prepare(query);
    }

    public PreparedStatement prepare(RegularStatement statement) {
        return this.delegate.prepare(statement);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        return this.delegate.prepareAsync(query);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(RegularStatement statement) {
        return this.delegate.prepareAsync(statement);
    }

    public void close() {
        this.delegate.close();
    }
}

